
import gurobi

def optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    mech_inf_companies = model.addVar(name="mechanized_infantry_companies", vtype=gurobi.GRB.INTEGER)
    med_platoons = model.addVar(name="medical_platoons", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(9 * mech_inf_companies ** 2 + 6 * mech_inf_companies * med_platoons + 2 * med_platoons ** 2 + med_platoons, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Total combined offensive capability rating squared >= 22
    model.addConstr(12 ** 2 * mech_inf_companies ** 2 + 1 ** 2 * med_platoons ** 2 >= 22, name="offensive_capability_rating_squared")

    # Total combined logistical capacity >= 40 and <= 107
    model.addConstr(18 * mech_inf_companies + 15 * med_platoons >= 40, name="logistical_capacity_lower")
    model.addConstr(18 * mech_inf_companies + 15 * med_platoons <= 107, name="logistical_capacity_upper")

    # Total combined fun factor >= 26 and <= 42
    model.addConstr(14 * mech_inf_companies + 9 * med_platoons >= 26, name="fun_factor_lower")
    model.addConstr(14 * mech_inf_companies + 9 * med_platoons <= 42, name="fun_factor_upper")

    # Total combined defensive capability rating squared >= 29 and <= 63
    model.addConstr(17 ** 2 * mech_inf_companies ** 2 + 11 ** 2 * med_platoons ** 2 >= 29, name="defensive_capability_rating_squared_lower")
    model.addConstr(17 * mech_inf_companies + 11 * med_platoons <= 63, name="defensive_capability_rating_upper")

    # Linear constraint
    model.addConstr(-7 * mech_inf_companies + 6 * med_platoons >= 0, name="linear_constraint")

    # Total combined offensive capability rating <= 102
    model.addConstr(12 * mech_inf_companies + med_platoons <= 102, name="offensive_capability_rating")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Mechanized Infantry Companies:", mech_inf_companies.varValue)
        print("Medical Platoons:", med_platoons.varValue)
        print("Objective Function Value:", model.objVal)
    else:
        print("The model is infeasible")

optimization_problem()
