
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
vitamin_c = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_c")
vitamin_b3 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b3")
vitamin_k = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_k")
vitamin_e = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_e")
vitamin_b1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b1")
vitamin_b12 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b12")

# Set objective function
model.setObjective(4 * vitamin_c + 6 * vitamin_b3 + 8 * vitamin_k + 6 * vitamin_e + 5 * vitamin_b1 + 3 * vitamin_b12, GRB.MAXIMIZE)

# Add constraints
model.addConstr(7.34 * vitamin_c + 11.69 * vitamin_e >= 24)
model.addConstr(2.84 * vitamin_b3 + 8.12 * vitamin_b1 >= 27)
model.addConstr(2.84 * vitamin_b3 + 8.22 * vitamin_k >= 16)
model.addConstr(8.12 * vitamin_b1 + 11.53 * vitamin_b12 >= 19)
model.addConstr(7.34 * vitamin_c + 8.12 * vitamin_b1 >= 20)
model.addConstr(11.69 * vitamin_e + 8.12 * vitamin_b1 >= 36)
model.addConstr(2.84 * vitamin_b3 + 11.53 * vitamin_b12 >= 13)
model.addConstr(2.84 * vitamin_b3 + 8.12 * vitamin_b1 + 11.53 * vitamin_b12 >= 40)
model.addConstr(2.84 * vitamin_b3 + 11.69 * vitamin_e + 11.53 * vitamin_b12 >= 40)
model.addConstr(11.69 * vitamin_e + 8.12 * vitamin_b1 + 11.53 * vitamin_b12 >= 40)
model.addConstr(7.34 * vitamin_c + 8.22 * vitamin_k + 8.12 * vitamin_b1 >= 40)
model.addConstr(8.22 * vitamin_k + 11.69 * vitamin_e + 8.12 * vitamin_b1 >= 40)
model.addConstr(2.84 * vitamin_b3 + 8.22 * vitamin_k + 11.69 * vitamin_e >= 40)
model.addConstr(7.34 * vitamin_c + 11.69 * vitamin_e + 11.53 * vitamin_b12 >= 40)
model.addConstr(7.34 * vitamin_c + 2.84 * vitamin_b3 + 11.53 * vitamin_b12 >= 40)
model.addConstr(8.22 * vitamin_k + 11.69 * vitamin_e + 11.53 * vitamin_b12 >= 40)
model.addConstr(7.34 * vitamin_c + 2.84 * vitamin_b3 + 8.12 * vitamin_b1 >= 40)
model.addConstr(7.34 * vitamin_c + 8.22 * vitamin_k + 11.69 * vitamin_e >= 40)
model.addConstr(2.84 * vitamin_b3 + 11.69 * vitamin_e + 8.12 * vitamin_b1 >= 40)

# ... (rest of the constraints, following the same pattern)

model.addConstr(8.12 * vitamin_b1 + 11.53 * vitamin_b12 <= 157)
model.addConstr(7.34 * vitamin_c + 2.84 * vitamin_b3 <= 69)
# ... (rest of the constraints, following the same pattern)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % model.status)
