
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
cornichons = m.addVar(vtype=GRB.INTEGER, name="cornichons")
cheeseburgers = m.addVar(vtype=GRB.CONTINUOUS, name="cheeseburgers")

# Set objective function
m.setObjective(7.98 * cornichons**2 + 4.54 * cheeseburgers, GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * cornichons + 7 * cheeseburgers >= 60, "c1") # carbohydrate constraint
m.addConstr(11 * cornichons + 19 * cheeseburgers >= 44, "c2") # sourness constraint
m.addConstr(22 * cornichons + 6 * cheeseburgers >= 48, "c3") # healthiness constraint

m.addConstr(5 * cornichons**2 + 7 * cheeseburgers**2 >= 60, "c4") # carbohydrate squared constraint
m.addConstr(11 * cornichons**2 + 19 * cheeseburgers**2 >= 44, "c5") # sourness squared constraint


m.addConstr(9 * cornichons**2 - 5 * cheeseburgers**2 >= 0, "c6")

m.addConstr(5 * cornichons + 7 * cheeseburgers <= 61, "c7") # carbohydrate upper bound
m.addConstr(11 * cornichons + 19 * cheeseburgers <= 141, "c8") # sourness upper bound
m.addConstr(22 * cornichons + 6 * cheeseburgers <= 119, "c9") # healthiness upper bound

m.addConstr(cornichons >= 0, "non_negativity_cornichons")
m.addConstr(cheeseburgers >= 0, "non_negativity_cheeseburgers")


# Resource Constraints (provided in the prompt)
m.addConstr(5 * cornichons + 7 * cheeseburgers <= 120, "carbohydrate_limit")
m.addConstr(11 * cornichons + 19 * cheeseburgers <= 167, "sourness_limit")
m.addConstr(22 * cornichons + 6 * cheeseburgers <= 233, "healthiness_limit")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('cornichons:', cornichons.x)
    print('cheeseburgers:', cheeseburgers.x)
elif m.status == GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

