
import gurobi

def optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    cornichons = model.addVar(name="cornichons", integer=True)
    cheeseburgers = model.addVar(name="cheeseburgers")

    # Objective function
    model.setObjective(7.98 * cornichons**2 + 4.54 * cheeseburgers**2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5 * cornichons + 7 * cheeseburgers >= 60, name="carbohydrates_min")
    model.addConstr(5 * cornichons + 7 * cheeseburgers <= 61, name="carbohydrates_max")

    model.addConstr(11 * cornichons + 19 * cheeseburgers >= 44, name="sourness_min")
    model.addConstr(11 * cornichons + 19 * cheeseburgers <= 141, name="sourness_max")

    model.addConstr(22 * cornichons + 6 * cheeseburgers >= 48, name="healthiness_min")
    model.addConstr(22 * cornichons + 6 * cheeseburgers <= 119, name="healthiness_max")

    model.addConstr(cornichons**2 + cheeseburgers**2 >= 60, name="squared_resources_min")

    model.addConstr(9 * cornichons**2 - 5 * cheeseburgers**2 >= 0, name="squared_terms")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution:")
        print(f"Cornichons: {cornichons.varValue}")
        print(f"Cheeseburgers: {cheeseburgers.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimization_problem()
