
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize_Work_Hours")

# Create variables
ringo_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ringo_hours")
george_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="george_hours")
mary_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="mary_hours")
peggy_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peggy_hours")

# Set objective function
model.setObjective(7 * ringo_hours**2 + 6 * ringo_hours * george_hours + ringo_hours * mary_hours + 8 * ringo_hours * peggy_hours + 3 * george_hours**2 + 3 * george_hours * mary_hours + 4 * george_hours * peggy_hours + 3 * mary_hours**2 + 6 * mary_hours * peggy_hours + 8 * peggy_hours**2 + 2 * ringo_hours + 3 * george_hours + 5 * mary_hours + 4 * peggy_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(11 * ringo_hours + 10 * george_hours >= 39, "c1")
model.addConstr(11 * ringo_hours**2 + 19 * peggy_hours**2 >= 61, "c2")
model.addConstr(10 * george_hours + 17 * mary_hours >= 68, "c3")
model.addConstr(11 * ringo_hours + 10 * george_hours + 17 * mary_hours + 19 * peggy_hours >= 68, "c4")
model.addConstr(ringo_hours + 2 * george_hours >= 22, "c5")
model.addConstr(ringo_hours + 17 * mary_hours >= 14, "c6")
model.addConstr(17 * mary_hours + 18 * peggy_hours >= 15, "c7")
model.addConstr(ringo_hours**2 + 4 * george_hours**2 + 289 * mary_hours**2 >= 43, "c8")
model.addConstr(ringo_hours + 17 * mary_hours + 18 * peggy_hours >= 43, "c9")
model.addConstr(ringo_hours**2 + 4 * george_hours**2 + 289 * mary_hours**2 >= 25, "c10")
model.addConstr(ringo_hours + 17 * mary_hours + 18 * peggy_hours >= 25, "c11")
model.addConstr(ringo_hours + 2 * george_hours + 17 * mary_hours + 18 * peggy_hours >= 25, "c12")
model.addConstr(17 * george_hours + 13 * peggy_hours >= 24, "c13")
model.addConstr(196 * ringo_hours**2 + 289 * george_hours**2 >= 19, "c14")
model.addConstr(14 * ringo_hours + 17 * george_hours + 16 * mary_hours >= 40, "c15")
model.addConstr(14 * ringo_hours + 16 * mary_hours + 13 * peggy_hours >= 40, "c16")
model.addConstr(196 * ringo_hours**2 + 256 * mary_hours**2 + 169 * peggy_hours**2 >= 27, "c17")
model.addConstr(14 * ringo_hours + 17 * george_hours + 16 * mary_hours + 13 * peggy_hours >= 27, "c18")
model.addConstr(6 * ringo_hours - 5 * peggy_hours >= 0, "c19")
model.addConstr(11 * ringo_hours + 17 * mary_hours + 19 * peggy_hours <= 299, "c20")
model.addConstr(10 * george_hours + 17 * mary_hours + 19 * peggy_hours <= 247, "c21")
model.addConstr(ringo_hours + 2 * george_hours <= 160, "c22")
model.addConstr(17 * mary_hours + 18 * peggy_hours <= 115, "c23")
model.addConstr(14 * ringo_hours + 13 * peggy_hours <= 190, "c24")
model.addConstr(289 * george_hours**2 + 256 * mary_hours**2 <= 164, "c25")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Ringo Hours:', ringo_hours.x)
    print('George Hours:', george_hours.x)
    print('Mary Hours:', mary_hours.x)
    print('Peggy Hours:', peggy_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % model.status)
