
import gurobi as gp
from gurobi import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
R = m.addVar(lb=0, name="Ringo")
G = m.addVar(lb=0, name="George")
M = m.addVar(lb=0, vtype=GRB.INTEGER, name="Mary")
P = m.addVar(lb=0, name="Peggy")

# Define the objective function
m.setObjective(7*R**2 + 6*R*G + R*M + 8*R*P + 3*G**2 + 3*G*M + 4*G*P + 3*M**2 + 6*M*P + 8*P**2 + 2*R + 3*G + 5*M + 4*P, GRB.MINIMIZE)

# Add constraints
m.addConstr(11*R <= 303)
m.addConstr(R <= 174)
m.addConstr(14*R <= 218)
m.addConstr(10*G <= 303)
m.addConstr(2*G <= 174)
m.addConstr(17*G <= 218)
m.addConstr(17*M <= 303)
m.addConstr(17*M <= 174)
m.addConstr(16*M <= 218)
m.addConstr(19*P <= 303)
m.addConstr(18*P <= 174)
m.addConstr(13*P <= 218)
m.addConstr(11*R + 10*G >= 39)
m.addConstr(11*R**2 + 19*P**2 >= 61)
m.addConstr(10*G + 17*M >= 68)
m.addConstr(11*R + 10*G + 17*M + 19*P >= 68)
m.addConstr(R + 2*G >= 22)
m.addConstr(R + 17*M >= 14)
m.addConstr(17*M + 18*P >= 15)
m.addConstr(R**2 + G**2 + M**2 >= 43)
m.addConstr(R + 17*M + 18*P >= 43)
m.addConstr(R**2 + G**2 + M**2 >= 25)
m.addConstr(R + 17*M + 18*P >= 25)
m.addConstr(R + G + M + P >= 25)
m.addConstr(17*G + 13*P >= 24)
m.addConstr(14*R**2 + 17*G**2 >= 19)
m.addConstr(14*R + 17*G + 16*M >= 40)
m.addConstr(14*R + 16*M + 13*P >= 40)
m.addConstr(14*R**2 + 17*G**2 + 16*M**2 >= 27)
m.addConstr(14*R**2 + 16*M**2 + 13*P**2 >= 27)
m.addConstr(14*R + 17*G + 16*M + 13*P >= 27)
m.addConstr(6*R - 5*P >= 0)
m.addConstr(11*R + 17*M + 13*P <= 299)
m.addConstr(10*G + 17*M + 13*P <= 247)
m.addConstr(R + 2*G <= 160)
m.addConstr(17*M + 18*P <= 115)
m.addConstr(14*R + 13*P <= 190)
m.addConstr(17*G**2 + 16*M**2 <= 164)

# Solve the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Ringo: ", R.varValue)
    print("George: ", G.varValue)
    print("Mary: ", M.varValue)
    print("Peggy: ", P.varValue)
else:
    print("The model is infeasible")
