
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("maximize_work_hours")

# Create variables
george_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="george_hours")
dale_hours = m.addVar(lb=0, vtype=GRB.INTEGER, name="dale_hours")

# Set objective function
m.setObjective(5.47 * george_hours**2 + 1.32 * george_hours * dale_hours + 4.27 * dale_hours**2 + 3.04 * george_hours + 1.6 * dale_hours, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6 * george_hours + 15 * dale_hours >= 37, "total_dollar_cost_min")
m.addConstr(-3 * george_hours + 5 * dale_hours >= 0, "hours_relation")
m.addConstr(6 * george_hours + 15 * dale_hours <= 44, "total_dollar_cost_max")
m.addConstr(6**2 * george_hours**2 + 15**2 * dale_hours**2 <= 44, "dollar_cost_squared_max")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"George's hours: {george_hours.x}")
    print(f"Dale's hours: {dale_hours.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

