
from gurobipy import *

# Create a new model
m = Model("Work_Hours_Optimization")

# Define the variables
G = m.addVar(vtype=GRB.CONTINUOUS, name="Hours_Worked_by_George")
D = m.addVar(vtype=GRB.INTEGER, name="Hours_Worked_by_Dale")

# Objective function
m.setObjective(5.47*G**2 + 1.32*G*D + 4.27*D**2 + 3.04*G + 1.6*D, GRB.MAXIMIZE)

# Constraints
m.addConstr(6*G + 15*D >= 37, name="Minimum_Combined_Dollar_Cost")
m.addConstr(-3*G + 5*D >= 0, name="Linear_Constraint_on_Hours")
m.addConstr(36*G**2 + 225*D**2 <= 44, name="Squared_Dollar_Costs_Sum") # Corrected constraint based on initial misinterpretation
m.addConstr(6*G + 15*D <= 44, name="Maximum_Combined_Dollar_Cost")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by George: {G.x}")
    print(f"Hours worked by Dale: {D.x}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found")
