
import gurobi

def optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    G = model.addVar(name="hours_worked_by_George", lb=0, ub=None)  # Non-integer
    D = model.addVar(name="hours_worked_by_Dale", lb=0, ub=None, integrality=gurobi.GRB.INTEGER)  # Integer

    # Objective function
    model.setObjective(5.47 * G**2 + 1.32 * G * D + 4.27 * D**2 + 3.04 * G + 1.6 * D, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6 * G + 15 * D >= 37, name="total_cost_min")
    model.addConstr(-3 * G + 5 * D >= 0, name="cost_ratio")
    model.addConstr(G**2 + D**2 <= 44, name="cost_squared_max")
    model.addConstr(G + D <= 44, name="total_hours_max")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by George: ", G.varValue)
        print("Hours worked by Dale: ", D.varValue)
    else:
        print("The model is infeasible")

optimization_problem()
