
from gurobipy import Model, GRB

# Create a new model
model = Model("food_optimization")

# Create variables
bacon = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bacon")
pickles = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pickles")
pasta = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pasta")

# Set objective function
model.setObjective(6.81 * bacon + 5.47 * pickles + 9.57 * pasta, GRB.MINIMIZE)

# Add constraints
model.addConstr(bacon + 13 * pickles + 4 * pasta <= 296, "iron_limit")  # Total iron limit
model.addConstr(10 * bacon + 9 * pickles + 11 * pasta <= 106, "sourness_limit")  # Total sourness limit
model.addConstr(bacon + 4 * pasta >= 55, "iron_bacon_pasta")  # Iron from bacon and pasta
model.addConstr(bacon + 13 * pickles >= 97, "iron_bacon_pickles")  # Iron from bacon and pickles
model.addConstr(bacon + 13 * pickles + 4 * pasta >= 74, "iron_total")  # Total iron minimum
model.addConstr(9 * pickles + 11 * pasta >= 16, "sourness_pickles_pasta")  # Sourness from pickles and pasta
model.addConstr(10 * bacon + 9 * pickles + 11 * pasta >= 16, "sourness_total")  # Total sourness minimum
model.addConstr(5 * bacon - 3 * pasta >= 0, "bacon_pasta_ratio")
model.addConstr(7 * bacon - 9 * pickles >= 0, "bacon_pickles_ratio")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Bacon: {bacon.x}")
    print(f"Pickles: {pickles.x}")
    print(f"Pasta: {pasta.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

