
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="strips_of_bacon", lb=0)  # strips of bacon
x1 = m.addVar(name="pickles", lb=0)  # pickles
x2 = m.addVar(name="bowls_of_pasta", lb=0)  # bowls of pasta

# Define the objective function
m.setObjective(6.81 * x0 + 5.47 * x1 + 9.57 * x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(x0 + 13 * x1 + 4 * x2 >= 74, "iron_total")
m.addConstr(x0 + 13 * x1 >= 97, "iron_bacon_pickles")
m.addConstr(10 * x0 + 9 * x1 + 11 * x2 >= 16, "sourness_total")
m.addConstr(5 * x0 - 3 * x2 >= 0, "bacon_pasta_constraint")
m.addConstr(7 * x0 - 9 * x1 >= 0, "bacon_pickles_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Strips of bacon: {x0.varValue}")
    print(f"Pickles: {x1.varValue}")
    print(f"Bowls of pasta: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
