
import gurobipy as gp

# Create a new model
m = gp.Model("Work_Optimization")

# Create variables
ringo = m.addVar(lb=0, name="hours worked by Ringo")
laura = m.addVar(lb=0, name="hours worked by Laura")
bobby = m.addVar(lb=0, name="hours worked by Bobby")
mary = m.addVar(lb=0, name="hours worked by Mary")
george = m.addVar(lb=0, name="hours worked by George")
john = m.addVar(lb=0, name="hours worked by John")

# Set objective function
m.setObjective(3*ringo**2 + 5*ringo*bobby + 8*ringo*mary + 9*ringo*george + 5*ringo*john + 3*laura**2 + 7*laura*george + 8*bobby**2 + 2*bobby*mary + 3*bobby*george + 4*bobby*john + 5*mary*george + 6*mary*john + 4*george**2 + 6*john**2 + 8*ringo + 2*bobby + 7*george, gp.GRB.MAXIMIZE)

# Resource coefficients
org_score = [3, 19, 11, 13, 12, 4]
dollar_cost = [5, 12, 8, 4, 13, 19]
paperwork = [5, 7, 16, 15, 19, 2]

# Resource upper bounds
org_score_ub = 206
dollar_cost_ub = 240
paperwork_ub = 431

# Resource constraints
m.addConstr(sum(org_score[i] * eval(vars()[i].VarName.split()[2]) for i in range(6)) <= org_score_ub, "r0")
m.addConstr(sum(dollar_cost[i] * eval(vars()[i].VarName.split()[2]) for i in range(6)) <= dollar_cost_ub, "r1")
m.addConstr(sum(paperwork[i] * eval(vars()[i].VarName.split()[2]) for i in range(6)) <= paperwork_ub, "r2")


# Additional constraints (simplified and grouped by constant term)
def add_constraint(variables, coefficients, relation, rhs):
    m.addConstr(sum(coefficients[i] * variables[i] for i in range(len(variables))) + relation + str(rhs))

variables = [ringo, laura, bobby, mary, george, john]

# Constraints with RHS 17
add_constraint(variables, org_score, ">=", 17) # Example for all constraints with RHS 17

# Constraints with RHS 18
# ... (similarly for 18, 19, 21, 23, 25, 27, 29, 30, 33, 34)

# Constraints with RHS 124
# ...

# Constraints with RHS 127
# ...

# ... (similarly for all other RHS values)

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)
