
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
hamburgers = m.addVar(vtype=gp.GRB.INTEGER, name="hamburgers")
oranges = m.addVar(vtype=gp.GRB.INTEGER, name="oranges")
ramen = m.addVar(vtype=gp.GRB.INTEGER, name="ramen")

# Set objective function
m.setObjective(6 * hamburgers + 7 * oranges + 9 * ramen, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * hamburgers + 11 * oranges + 1 * ramen <= 114, "carbohydrate_limit") # Total carbohydrate constraint
m.addConstr(4 * hamburgers + 7 * oranges + 9 * ramen <= 132, "tastiness_limit") # Total tastiness constraint
m.addConstr(8 * hamburgers + 11 * oranges >= 29, "carbohydrate_hamburgers_oranges")
m.addConstr(8 * hamburgers + 1 * ramen >= 30, "carbohydrate_hamburgers_ramen")
m.addConstr(8 * hamburgers + 11 * oranges + 1 * ramen >= 30, "carbohydrate_total")
m.addConstr(4 * hamburgers + 7 * oranges >= 37, "tastiness_hamburgers_oranges")
m.addConstr(7 * oranges + 9 * ramen >= 39, "tastiness_oranges_ramen")
m.addConstr(4 * hamburgers + 7 * oranges + 9 * ramen >= 22, "tastiness_total_1") # Redundant constraint, but included as specified
m.addConstr(4 * hamburgers + 7 * oranges + 9 * ramen >= 22, "tastiness_total_2") # Redundant constraint, but included as specified


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective: %g' % m.objVal)
    print('hamburgers:', hamburgers.x)
    print('oranges:', oranges.x)
    print('ramen:', ramen.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

