
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
hamburgers = m.addVar(vtype=GRB.INTEGER, name="hamburgers")
oranges = m.addVar(vtype=GRB.INTEGER, name="oranges")
ramen = m.addVar(vtype=GRB.INTEGER, name="bowls_of_instant_ramen")

# Set objective function
m.setObjective(6*hamburgers + 7*oranges + 9*ramen, GRB.MINIMIZE)

# Add constraints
m.addConstr(8*hamburgers + 11*oranges >= 29, name="carbs_hamburgers_oranges")
m.addConstr(8*hamburgers + ramen >= 30, name="carbs_hamburgers_ramen")
m.addConstr(8*hamburgers + 11*oranges + ramen >= 30, name="total_carbs")
m.addConstr(4*hamburgers + 7*oranges >= 37, name="tastiness_hamburgers_oranges")
m.addConstr(7*oranges + 9*ramen >= 39, name="tastiness_oranges_ramen")
m.addConstr(4*hamburgers + 7*oranges + 9*ramen >= 22, name="total_tastiness")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Hamburgers:", hamburgers.x)
    print("Oranges:", oranges.x)
    print("Bowls of instant ramen:", ramen.x)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found")
