
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    hamburgers = model.addVar(name="hamburgers", vtype=gurobi.GRB.INTEGER)
    oranges = model.addVar(name="oranges", vtype=gurobi.GRB.INTEGER)
    bowls_of_instant_ramen = model.addVar(name="bowls_of_instant_ramen", vtype=gurobi.GRB.INTEGER)

    # Objective function: Minimize 6*hamburgers + 7*oranges + 9*bowls_of_instant_ramen
    model.setObjective(6 * hamburgers + 7 * oranges + 9 * bowls_of_instant_ramen, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8 * hamburgers + 11 * oranges >= 29, name="carbohydrates_hamburgers_oranges")
    model.addConstr(8 * hamburgers + bowls_of_instant_ramen >= 30, name="carbohydrates_hamburgers_ramen")
    model.addConstr(8 * hamburgers + 11 * oranges + bowls_of_instant_ramen >= 30, name="total_carbohydrates")

    model.addConstr(4 * hamburgers + 7 * oranges >= 37, name="tastiness_hamburgers_oranges")
    model.addConstr(7 * oranges + 9 * bowls_of_instant_ramen >= 39, name="tastiness_oranges_ramen")
    model.addConstr(4 * hamburgers + 7 * oranges + 9 * bowls_of_instant_ramen >= 22, name="total_tastiness")

    # Resource constraints (not explicitly mentioned but implied)
    r0 = model.addConstr(8 * hamburgers + 11 * oranges + bowls_of_instant_ramen <= 114, name="carbohydrates_upper_bound")
    r1 = model.addConstr(4 * hamburgers + 7 * oranges + 9 * bowls_of_instant_ramen <= 132, name="tastiness_upper_bound")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hamburgers: {hamburgers.varValue}")
        print(f"Oranges: {oranges.varValue}")
        print(f"Bowls of instant ramen: {bowls_of_instant_ramen.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
