
from gurobipy import Model, GRB

# Create a new model
model = Model("protein_optimization")

# Create variables
ham_sandwiches = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ham_sandwiches")
chicken_thighs = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_thighs")
rotisserie_chickens = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="rotisserie_chickens")
steaks = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="steaks")
strips_of_bacon = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="strips_of_bacon")
cantaloupes = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cantaloupes")

# Set objective function
model.setObjective(6.97 * ham_sandwiches * chicken_thighs + 1.95 * ham_sandwiches * rotisserie_chickens + 4.26 * ham_sandwiches * steaks + 3.64 * ham_sandwiches * strips_of_bacon + 4.75 * ham_sandwiches * cantaloupes + 4.24 * chicken_thighs * chicken_thighs + 9.26 * chicken_thighs * rotisserie_chickens + 6.36 * rotisserie_chickens * rotisserie_chickens + 4.49 * steaks * steaks + 1.52 * steaks * strips_of_bacon + 7.28 * strips_of_bacon * cantaloupes + 7.75 * chicken_thighs + 3.98 * steaks + 6.93 * strips_of_bacon + 5.3 * cantaloupes, GRB.MAXIMIZE)

# Add constraints
model.addConstr(11 * ham_sandwiches + 10 * chicken_thighs + 10 * rotisserie_chickens + 14 * steaks + 6 * strips_of_bacon + 12 * cantaloupes <= 178, "protein_limit")
model.addConstr((11 * ham_sandwiches) * (11 * ham_sandwiches) + (10 * rotisserie_chickens) * (10 * rotisserie_chickens) <= 158, "protein_squared_1")
model.addConstr((10 * chicken_thighs) * (10 * chicken_thighs) + (6 * strips_of_bacon) * (6 * strips_of_bacon) <= 152, "protein_squared_2")
model.addConstr(6 * strips_of_bacon + 12 * cantaloupes <= 36, "protein_combined_1")
model.addConstr(11 * ham_sandwiches + 10 * chicken_thighs <= 44, "protein_combined_2")
model.addConstr(10 * rotisserie_chickens + 12 * cantaloupes <= 53, "protein_combined_3")
model.addConstr(11 * ham_sandwiches + 14 * steaks <= 102, "protein_combined_4")
model.addConstr(10 * rotisserie_chickens + 6 * strips_of_bacon <= 168, "protein_combined_5")
model.addConstr((10 * chicken_thighs) * (10 * chicken_thighs) + (10 * rotisserie_chickens) * (10 * rotisserie_chickens) <= 51, "protein_squared_3")
model.addConstr(10 * chicken_thighs + 14 * steaks <= 118, "protein_combined_6")
model.addConstr((10 * chicken_thighs) * (10 * chicken_thighs) + (12 * cantaloupes) * (12 * cantaloupes) <= 171, "protein_squared_4")
model.addConstr(11 * ham_sandwiches + 10 * chicken_thighs + 10 * rotisserie_chickens + 14 * steaks + 6 * strips_of_bacon + 12 * cantaloupes <= 171, "total_protein")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

