
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="ham_sandwiches", lb=0)  # ham sandwiches
x1 = m.addVar(name="chicken_thighs", lb=0)  # chicken thighs
x2 = m.addVar(name="rotisserie_chickens", lb=0)  # rotisserie chickens
x3 = m.addVar(name="steaks", lb=0)  # steaks
x4 = m.addVar(name="strips_of_bacon", lb=0)  # strips of bacon
x5 = m.addVar(name="cantaloupes", lb=0)  # cantaloupes

# Objective function
m.setObjective(6.97*x0*x1 + 1.95*x0*x2 + 4.26*x0*x3 + 3.64*x0*x4 + 4.75*x0*x5 +
               4.24*x1**2 + 9.26*x1*x2 + 6.36*x2**2 + 4.49*x3**2 + 1.52*x3*x4 +
               7.28*x4*x5 + 7.75*x1 + 3.98*x3 + 6.93*x4 + 5.3*x5, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(11*x0 + 10*x1 + 10*x2 + 14*x3 + 6*x4 + 12*x5 <= 178)
m.addConstr(121*x0**2 + 100*x2**2 <= 158)
m.addConstr(100*x1**2 + 36*x4**2 <= 152)
m.addConstr(6*x4 + 12*x5 <= 36)
m.addConstr(11*x0 + 10*x1 <= 44)
m.addConstr(10*x2 + 12*x5 <= 53)
m.addConstr(11*x0 + 14*x3 <= 102)
m.addConstr(10*x2 + 6*x4 <= 168)
m.addConstr(100*x1**2 + 100*x2**2 <= 51)
m.addConstr(10*x1 + 14*x3 <= 118)
m.addConstr(100*x1**2 + 144*x5**2 <= 171)
m.addConstr(11*x0 + 10*x1 + 10*x2 + 14*x3 + 6*x4 + 12*x5 <= 171)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("ham sandwiches: ", x0.varValue)
    print("chicken thighs: ", x1.varValue)
    print("rotisserie chickens: ", x2.varValue)
    print("steaks: ", x3.varValue)
    print("strips of bacon: ", x4.varValue)
    print("cantaloupes: ", x5.varValue)
else:
    print("The model is infeasible")
