
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
chives = m.addVar(vtype=GRB.INTEGER, name="chives")
agave = m.addVar(vtype=GRB.INTEGER, name="agave")
squash_plants = m.addVar(vtype=GRB.INTEGER, name="squash_plants")
carrots = m.addVar(vtype=GRB.INTEGER, name="carrots")

# Set objective function
m.setObjective(6*chives**2 + 7*chives*carrots + 4*agave*squash_plants + 7*squash_plants + 2*carrots, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*agave + 11*carrots >= 28, "c1")
m.addConstr(12*chives + 13*agave + 11*squash_plants >= 16, "c2")
m.addConstr(12*chives**2 + 13*agave**2 + 6*carrots**2 >= 16, "c3")
m.addConstr(12*chives**2 + 13*agave**2 + 11*squash_plants**2 >= 25, "c4")
m.addConstr(12*chives**2 + 13*agave**2 + 6*carrots**2 >= 25, "c5") # Redundant constraint, same as c3
m.addConstr(10*chives**2 + 6*carrots**2 >= 47, "c6")
m.addConstr(14*squash_plants + 6*carrots >= 22, "c7")
m.addConstr(4*agave + 14*squash_plants >= 21, "c8")
m.addConstr(4*agave**2 + 14*squash_plants**2 + 6*carrots**2 >= 33, "c9")
m.addConstr(-4*squash_plants**2 + carrots**2 >= 0, "c10")
m.addConstr(14*chives**2 + 7*squash_plants**2 <= 69, "c11")
m.addConstr(14*chives + 8*agave <= 42, "c12")
m.addConstr(14*chives + 11*carrots <= 92, "c13")
m.addConstr(7*squash_plants + 11*carrots <= 62, "c14")
m.addConstr(14*chives**2 + 8*agave**2 + 11*carrots**2 <= 135, "c15")
m.addConstr(14*chives + 8*agave + 7*squash_plants + 11*carrots <= 135, "c16") # Resource constraint 'r0'
m.addConstr(12*chives + 11*squash_plants <= 71, "c17")
m.addConstr(13*agave + 6*carrots <= 77, "c18")
m.addConstr(12*chives + 13*agave + 11*squash_plants <= 45, "c19")
m.addConstr(12*chives + 13*agave + 11*squash_plants + 6*carrots <= 45, "c20") # Resource constraint 'r1'
m.addConstr(10*chives + 4*agave <= 120, "c21")
m.addConstr(14*squash_plants + 6*carrots <= 161, "c22")
m.addConstr(4*agave + 14*squash_plants <= 56, "c23")
m.addConstr(10*chives**2 + 4*agave**2 + 14*squash_plants**2 <= 160, "c24")
m.addConstr(10*chives + 14*squash_plants + 6*carrots <= 174, "c25")
m.addConstr(10*chives + 4*agave + 14*squash_plants + 6*carrots <= 174, "c26") # Resource constraint 'r2'


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('chives:', chives.x)
    print('agave:', agave.x)
    print('squash_plants:', squash_plants.x)
    print('carrots:', carrots.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
