
from gurobipy import Model, GRB

# Create a new model
model = Model("food_optimization")

# Create variables
foods = ['peanutbutter sandwiches', 'bananas', 'hamburgers', 'strawberries', 'black beans']
x = model.addVars(foods, vtype=GRB.INTEGER, name=foods)

# Set objective function
model.setObjective(8.8 * x['peanutbutter sandwiches'] + 9.13 * x['bananas'] + 6.84 * x['hamburgers'] + 8.77 * x['strawberries'] + 3.21 * x['black beans'], GRB.MINIMIZE)

# Add constraints
dollar_cost = {'peanutbutter sandwiches': 18, 'bananas': 25, 'hamburgers': 5, 'strawberries': 14, 'black beans': 20}
iron = {'peanutbutter sandwiches': 18, 'bananas': 22, 'hamburgers': 5, 'strawberries': 18, 'black beans': 1}

model.addConstr(18 * x['peanutbutter sandwiches'] + 25 * x['bananas'] + 5 * x['hamburgers'] + 14 * x['strawberries'] + 20 * x['black beans'] <= 244, "r0_upper_bound") # dollar cost upper bound
model.addConstr(18 * x['peanutbutter sandwiches'] + 22 * x['bananas'] + 5 * x['hamburgers'] + 18 * x['strawberries'] + 1 * x['black beans'] <= 151, "r1_upper_bound") # iron upper bound


model.addConstr(25 * x['bananas'] + 20 * x['black beans'] >= 35, "c1")
model.addConstr(18 * x['peanutbutter sandwiches'] + 14 * x['strawberries'] >= 42, "c2")
model.addConstr(25 * x['bananas'] + 14 * x['strawberries'] >= 38, "c3")
model.addConstr(14 * x['strawberries'] + 20 * x['black beans'] >= 33, "c4")
model.addConstr(25 * x['bananas'] + 14 * x['strawberries'] + 20 * x['black beans'] >= 25, "c5")
model.addConstr(sum(dollar_cost[f] * x[f] for f in foods) >= 25, "c6")

model.addConstr(18 * x['peanutbutter sandwiches'] + 5 * x['hamburgers'] >= 12, "c7")
model.addConstr(18 * x['peanutbutter sandwiches'] + 18 * x['strawberries'] >= 14, "c8")
model.addConstr(18 * x['peanutbutter sandwiches'] + 22 * x['bananas'] + 1 * x['black beans'] >= 22, "c9")
model.addConstr(18 * x['peanutbutter sandwiches'] + 5 * x['hamburgers'] + 1 * x['black beans'] >= 22, "c10")
model.addConstr(18 * x['peanutbutter sandwiches'] + 18 * x['strawberries'] + 1 * x['black beans'] >= 22, "c11")
model.addConstr(22 * x['bananas'] + 5 * x['hamburgers'] + 1 * x['black beans'] >= 22, "c12")
model.addConstr(18 * x['peanutbutter sandwiches'] + 22 * x['bananas'] + 18 * x['strawberries'] >= 22, "c13")
model.addConstr(18 * x['peanutbutter sandwiches'] + 5 * x['hamburgers'] + 18 * x['strawberries'] >= 22, "c14")
model.addConstr(5 * x['hamburgers'] + 18 * x['strawberries'] + 1 * x['black beans'] >= 22, "c15")

# Constraints c16-c32 (similar structure as c9-c15, just with different RHS values)
for rhs in [23, 24, 26, 20, 30, 19]:
    model.addConstr(18 * x['peanutbutter sandwiches'] + 22 * x['bananas'] + 1 * x['black beans'] >= rhs, f"c{15+rhs-21}_a")
    model.addConstr(18 * x['peanutbutter sandwiches'] + 5 * x['hamburgers'] + 1 * x['black beans'] >= rhs, f"c{15+rhs-21}_b")
    model.addConstr(18 * x['peanutbutter sandwiches'] + 18 * x['strawberries'] + 1 * x['black beans'] >= rhs, f"c{15+rhs-21}_c")
    model.addConstr(22 * x['bananas'] + 5 * x['hamburgers'] + 1 * x['black beans'] >= rhs, f"c{15+rhs-21}_d")
    model.addConstr(18 * x['peanutbutter sandwiches'] + 22 * x['bananas'] + 18 * x['strawberries'] >= rhs, f"c{15+rhs-21}_e")
    model.addConstr(18 * x['peanutbutter sandwiches'] + 5 * x['hamburgers'] + 18 * x['strawberries'] >= rhs, f"c{15+rhs-21}_f")
    model.addConstr(5 * x['hamburgers'] + 18 * x['strawberries'] + 1 * x['black beans'] >= rhs, f"c{15+rhs-21}_g")

model.addConstr(sum(iron[f] * x[f] for f in foods) >= 19, "c48") # Total iron constraint

model.addConstr(-x['peanutbutter sandwiches'] + 3 * x['bananas'] >= 0, "c49")
model.addConstr(18 * x['peanutbutter sandwiches'] + 25 * x['bananas'] <= 218, "c50")
model.addConstr(25 * x['bananas'] + 20 * x['black beans'] <= 164, "c51")
model.addConstr(25 * x['bananas'] + 5 * x['hamburgers'] + 20 * x['black beans'] <= 89, "c52")
model.addConstr(25 * x['bananas'] + 14 * x['strawberries'] + 20 * x['black beans'] <= 186, "c53")
model.addConstr(18 * x['peanutbutter sandwiches'] + 5 * x['hamburgers'] + 14 * x['strawberries'] <= 210, "c54")
model.addConstr(18 * x['peanutbutter sandwiches'] + 1 * x['black beans'] <= 105, "c55")
model.addConstr(18 * x['peanutbutter sandwiches'] + 18 * x['strawberries'] <= 57, "c56")
model.addConstr(22 * x['bananas'] + 5 * x['hamburgers'] + 18 * x['strawberries'] <= 117, "c57")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")
