
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define decision variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_C")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B7")

# Define the objective function
m.setObjective(3.56*x0 + 9.33*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5.67*x0 + 6.06*x1 >= 84, "cardiovascular_support_index_min")
m.addConstr(5.67*x0 + 6.06*x1 <= 248, "cardiovascular_support_index_max")
m.addConstr(0.73*x0 + 4.16*x1 >= 21, "digestive_support_index_min")
m.addConstr(0.73*x0 + 4.16*x1 <= 90, "digestive_support_index_max")
m.addConstr(0.37*x0 + 1.26*x1 >= 48, "kidney_support_index_min")
m.addConstr(0.37*x0 + 1.26*x1 <= 128, "kidney_support_index_max")
m.addConstr(3.56*x0 + 1.87*x1 >= 58, "energy_stability_index_min")
m.addConstr(3.56*x0 + 1.87*x1 <= 127, "energy_stability_index_max")
m.addConstr(5*x0 - 3*x1 >= 0, "additional_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"milligrams_of_vitamin_C: {x0.x}")
    print(f"milligrams_of_vitamin_B7: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
