
import gurobipy as gp

# Create a new model
model = gp.Model("Vitamin_Optimization")

# Define the variables
vitamin_C = model.addVar(name="vitamin_C", lb=0)  # Allow non-integer values
vitamin_B7 = model.addVar(name="vitamin_B7", lb=0)  # Allow non-integer values

# Define the objective function
model.setObjective(3.56 * vitamin_C + 9.33 * vitamin_B7, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5.67 * vitamin_C + 6.06 * vitamin_B7 >= 84, name="cardiovascular_support_min")
model.addConstr(5.67 * vitamin_C + 6.06 * vitamin_B7 <= 248, name="cardiovascular_support_max")
model.addConstr(0.73 * vitamin_C + 4.16 * vitamin_B7 >= 21, name="digestive_support_min")
model.addConstr(0.73 * vitamin_C + 4.16 * vitamin_B7 <= 90, name="digestive_support_max")
model.addConstr(0.37 * vitamin_C + 1.26 * vitamin_B7 >= 48, name="kidney_support_min")
model.addConstr(0.37 * vitamin_C + 1.26 * vitamin_B7 <= 128, name="kidney_support_max")
model.addConstr(3.56 * vitamin_C + 1.87 * vitamin_B7 >= 58, name="energy_stability_min")
model.addConstr(3.56 * vitamin_C + 1.87 * vitamin_B7 <= 127, name="energy_stability_max")
model.addConstr(5 * vitamin_C - 3 * vitamin_B7 >= 0, name="additional_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin C: {vitamin_C.varValue}")
    print(f"Milligrams of vitamin B7: {vitamin_B7.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
