
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
bobby = m.addVar(name="bobby", lowBound=0, integrality=1)
dale = m.addVar(name="dale", lowBound=0, integrality=1)
george = m.addVar(name="george", lowBound=0, integrality=1)
jean = m.addVar(name="jean", lowBound=0, integrality=1)
paul = m.addVar(name="paul", lowBound=0, integrality=1)

# Define the objective function
m.setObjective(3.31 * bobby + 6.55 * dale + 6.49 * george + 4.5 * jean + 8.58 * paul, gp.GRB.MAXIMIZE)

# Define the constraints
# Likelihood to quit index constraints
m.addConstr(22 * bobby + 0 * dale + 19 * george + 19 * jean + 0 * paul >= 29)
m.addConstr(0 * bobby + 20 * dale + 19 * george + 0 * jean + 35 * paul >= 29)
m.addConstr(0 * bobby + 19 * george + 19 * jean + 35 * paul >= 29)
m.addConstr(22 * bobby + 0 * dale + 19 * george + 19 * jean + 0 * paul >= 25)
m.addConstr(0 * bobby + 20 * dale + 19 * george + 0 * jean + 35 * paul >= 25)
m.addConstr(0 * bobby + 19 * george + 19 * jean + 35 * paul >= 25)
m.addConstr(22 * bobby + 0 * dale + 19 * george + 19 * jean + 0 * paul >= 47)
m.addConstr(0 * bobby + 20 * dale + 19 * george + 0 * jean + 35 * paul >= 47)
m.addConstr(0 * bobby + 19 * george + 19 * jean + 35 * paul >= 47)

# Organization score constraints
m.addConstr(10 * bobby + 13 * dale + 0 * george + 2 * jean + 15 * paul >= 29)
m.addConstr(0 * bobby + 13 * dale + 20 * george + 2 * jean + 0 * paul >= 49)
m.addConstr(10 * bobby + 13 * dale + 20 * george + 0 * jean + 0 * paul >= 56)
m.addConstr(0 * bobby + 2 * jean + 15 * paul >= 38)
m.addConstr(10 * bobby + 0 * dale + 0 * george + 0 * jean + 15 * paul >= 53)
m.addConstr(10 * bobby + 13 * dale + 0 * george + 2 * jean + 0 * paul >= 67)
m.addConstr(10 * bobby + 0 * dale + 20 * george + 0 * jean + 0 * paul >= 34)
m.addConstr(0 * bobby + 13 * dale + 2 * jean + 15 * paul >= 53)
m.addConstr(0 * bobby + 20 * george + 2 * jean + 15 * paul >= 53)
m.addConstr(10 * bobby + 13 * dale + 0 * george + 0 * jean + 15 * paul >= 53)
m.addConstr(0 * bobby + 13 * dale + 2 * jean + 15 * paul >= 60)
m.addConstr(0 * bobby + 20 * george + 2 * jean + 15 * paul >= 60)
m.addConstr(10 * bobby + 13 * dale + 0 * george + 0 * jean + 15 * paul >= 60)
m.addConstr(0 * bobby + 13 * dale + 2 * jean + 15 * paul >= 50)
m.addConstr(0 * bobby + 20 * george + 2 * jean + 15 * paul >= 50)
m.addConstr(10 * bobby + 13 * dale + 0 * george + 0 * jean + 15 * paul >= 50)

# Dollar cost per hour constraints
m.addConstr(19 * dale + 4 * jean >= 40)
m.addConstr(35 * bobby + 4 * jean >= 37)
m.addConstr(35 * bobby + 33 * george + 16 * paul >= 23)
m.addConstr(35 * bobby + 19 * dale + 4 * jean >= 23)
m.addConstr(35 * bobby + 33 * george + 16 * paul >= 41)
m.addConstr(35 * bobby + 19 * dale + 4 * jean >= 41)

# Productivity rating constraints
m.addConstr(15 * dale + 1 * jean >= 30)
m.addConstr(15 * bobby + 15 * paul >= 35)
m.addConstr(25 * george + 15 * paul >= 32)
m.addConstr(15 * bobby + 25 * george + 15 * paul >= 39)

# Work quality rating constraints
m.addConstr(34 * bobby + 4 * paul >= 28)
m.addConstr(25 * dale + 17 * jean >= 36)
m.addConstr(34 * bobby + 17 * jean >= 18)
m.addConstr(34 * bobby + 5 * george + 17 * jean >= 53)
m.addConstr(25 * dale + 5 * george + 4 * paul >= 53)
m.addConstr(34 * bobby + 25 * dale + 17 * jean >= 53)
m.addConstr(34 * bobby + 5 * george + 4 * paul >= 53)

# Other constraints
m.addConstr(10 * dale - 5 * jean >= 0)
m.addConstr(5 * dale + 9 * jean - 7 * paul >= 0)
m.addConstr(19 * george + 35 * paul <= 99)
m.addConstr(22 * bobby + 20 * dale <= 248)
m.addConstr(20 * dale + 19 * george <= 75)
m.addConstr(22 * bobby + 19 * george + 35 * paul <= 213)
m.addConstr(20 * dale + 19 * george + 35 * paul <= 204)
m.addConstr(22 * bobby + 19 * george + 19 * jean <= 174)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Bobby: ", bobby.varValue)
    print("Dale: ", dale.varValue)
    print("George: ", george.varValue)
    print("Jean: ", jean.varValue)
    print("Paul: ", paul.varValue)
else:
    print("No solution found")
