
from gurobipy import Model, GRB

# Create a new model
m = Model("resource_optimization")

# Create variables
patches_per_day = m.addVar(vtype=GRB.INTEGER, name="patches_per_day")
intrusion_analysts = m.addVar(vtype=GRB.INTEGER, name="intrusion_analysts")
security_engineers = m.addVar(vtype=GRB.INTEGER, name="security_engineers")
system_administrators = m.addVar(vtype=GRB.INTEGER, name="system_administrators")

# Set objective function
m.setObjective(7 * patches_per_day + 6 * intrusion_analysts + 5 * security_engineers + 4 * system_administrators, GRB.MINIMIZE)

# Add constraints
m.addConstr(20 * patches_per_day + 14 * intrusion_analysts <= 313, "r0_network_latency")  # Network Latency
m.addConstr(5 * patches_per_day + 5 * intrusion_analysts + 21 * security_engineers + 8 * system_administrators <= 343, "r1_data_confidentiality")  # Data Confidentiality
m.addConstr(18 * patches_per_day + 15 * intrusion_analysts + 14 * security_engineers + 5 * system_administrators <= 259, "r2_power_consumption")  # Power Consumption

m.addConstr(20 * patches_per_day + 14 * intrusion_analysts >= 40, "network_latency_1")
m.addConstr(20 * patches_per_day + 14 * system_administrators >= 58, "network_latency_2")
m.addConstr(14 * intrusion_analysts + 2 * security_engineers + 14 * system_administrators >= 57, "network_latency_3")
m.addConstr(20 * patches_per_day + 14 * intrusion_analysts + 2 * security_engineers + 14 * system_administrators >= 57, "network_latency_4")

m.addConstr(5 * intrusion_analysts + 8 * system_administrators >= 51, "data_confidentiality_1")
m.addConstr(5 * patches_per_day + 5 * intrusion_analysts + 21 * security_engineers + 8 * system_administrators >= 51, "data_confidentiality_2")

m.addConstr(14 * security_engineers + 5 * system_administrators >= 63, "power_consumption_1")
m.addConstr(15 * intrusion_analysts + 14 * security_engineers >= 60, "power_consumption_2")
m.addConstr(18 * patches_per_day + 5 * system_administrators >= 62, "power_consumption_3")
m.addConstr(15 * intrusion_analysts + 5 * system_administrators >= 61, "power_consumption_4")
m.addConstr(18 * patches_per_day + 14 * security_engineers >= 51, "power_consumption_5")
m.addConstr(18 * patches_per_day + 15 * intrusion_analysts >= 49, "power_consumption_6")
m.addConstr(18 * patches_per_day + 15 * intrusion_analysts + 14 * security_engineers + 5 * system_administrators >= 49, "power_consumption_7")


m.addConstr(10 * patches_per_day - 5 * security_engineers >= 0, "constraint_1")
m.addConstr(-1 * security_engineers + 9 * system_administrators >= 0, "constraint_2")

m.addConstr(20 * patches_per_day + 2 * security_engineers <= 265, "network_latency_upper_1")
m.addConstr(14 * intrusion_analysts + 2 * security_engineers <= 145, "network_latency_upper_2")
m.addConstr(20 * patches_per_day + 14 * intrusion_analysts <= 79, "network_latency_upper_3")
m.addConstr(20 * patches_per_day + 14 * system_administrators <= 97, "network_latency_upper_4")
m.addConstr(20 * patches_per_day + 14 * intrusion_analysts + 14 * system_administrators <= 262, "network_latency_upper_5")

m.addConstr(5 * intrusion_analysts + 21 * security_engineers + 8 * system_administrators <= 279, "data_confidentiality_upper_1")

m.addConstr(15 * intrusion_analysts + 5 * system_administrators <= 96, "power_consumption_upper_1")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

