
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
paul = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Paul")
hank = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Hank")
john = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="John")
mary = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Mary")

# Set objective function
model.setObjective(3.68 * paul + 2.07 * hank + 5.86 * john + 3.14 * mary, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(8 * paul + 4 * hank >= 12, "c1")
model.addConstr(8 * paul + 13 * john >= 11, "c2")
model.addConstr(13 * john + 7 * mary >= 13, "c3")
model.addConstr(4 * hank + 7 * mary >= 30, "c4")
model.addConstr(4 * hank + 7 * mary <= 127, "c5")
model.addConstr(13 * john + 7 * mary <= 34, "c6")
model.addConstr(8 * paul + 4 * hank <= 96, "c7")
model.addConstr(4 * hank + 13 * john + 7 * mary <= 38, "c8")
model.addConstr(8 * paul + 4 * hank + 13 * john + 7 * mary <= 38, "c9")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

