
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
Paul = m.addVar(name="hours_worked_by_Paul", lb=0)
Hank = m.addVar(name="hours_worked_by_Hank", lb=0)
John = m.addVar(name="hours_worked_by_John", lb=0)
Mary = m.addVar(name="hours_worked_by_Mary", lb=0)

# Define the objective function
m.setObjective(3.68 * Paul + 2.07 * Hank + 5.86 * John + 3.14 * Mary, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8 * Paul + 4 * Hank >= 12, name="Paul_Hank_min")
m.addConstr(8 * Paul + 13 * John >= 11, name="Paul_John_min")
m.addConstr(13 * John + 7 * Mary >= 13, name="John_Mary_min")
m.addConstr(4 * Hank + 7 * Mary >= 30, name="Hank_Mary_min")
m.addConstr(4 * Hank + 7 * Mary <= 127, name="Hank_Mary_max")
m.addConstr(13 * John + 7 * Mary <= 34, name="John_Mary_max")
m.addConstr(8 * Paul + 4 * Hank <= 96, name="Paul_Hank_max")
m.addConstr(4 * Hank + 13 * John + 7 * Mary <= 38, name="Hank_John_Mary_max")
m.addConstr(8 * Paul + 4 * Hank + 13 * John + 7 * Mary <= 38, name="All_max")

# Optimize the model
m.optimize()

# Print the solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
