
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    P = model.addVar(lb=0, name="hours_worked_by_Paul")
    H = model.addVar(lb=0, name="hours_worked_by_Hank")
    J = model.addVar(lb=0, name="hours_worked_by_John")
    M = model.addVar(lb=0, name="hours_worked_by_Mary")

    # Objective function: Maximize 3.68P + 2.07H + 5.86J + 3.14M
    model.setObjective(3.68 * P + 2.07 * H + 5.86 * J + 3.14 * M, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(8 * P + 4 * H >= 12, name="constraint_1")
    model.addConstr(8 * P + 13 * J >= 11, name="constraint_2")
    model.addConstr(13 * J + 7 * M >= 13, name="constraint_3")
    model.addConstr(4 * H + 7 * M >= 30, name="constraint_4")
    model.addConstr(4 * H + 7 * M <= 127, name="constraint_5")
    model.addConstr(13 * J + 7 * M <= 34, name="constraint_6")
    model.addConstr(8 * P + 4 * H <= 96, name="constraint_7")
    model.addConstr(4 * H + 13 * J + 7 * M <= 38, name="constraint_8")
    model.addConstr(8 * P + 4 * H + 13 * J + 7 * M <= 38, name="constraint_9")

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Paul: {P.varValue}")
        print(f"Hours worked by Hank: {H.varValue}")
        print(f"Hours worked by John: {J.varValue}")
        print(f"Hours worked by Mary: {M.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

optimization_problem()
