
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
george_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george_hours")
john_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john_hours")
laura_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")
bobby_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby_hours")
mary_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary_hours")
hank_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank_hours")
paul_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul_hours")


# Set objective function
model.setObjective(6.15 * george_hours + 4.52 * john_hours + 6.66 * laura_hours + 7.61 * bobby_hours + 1.6 * mary_hours + 4.75 * hank_hours + 6.55 * paul_hours, gp.GRB.MAXIMIZE)

# Resource data
resources = {'r0': {'description': 'computer competence rating', 'upper_bound': 747, 'x0': 9, 'x1': 8, 'x2': 24, 'x3': 34, 'x4': 34, 'x5': 3, 'x6': 20}, 
            'r1': {'description': 'likelihood to quit index', 'upper_bound': 734, 'x0': 33, 'x1': 20, 'x2': 4, 'x3': 13, 'x4': 1, 'x5': 11, 'x6': 5}, 
            'r2': {'description': 'work quality rating', 'upper_bound': 804, 'x0': 14, 'x1': 17, 'x2': 8, 'x3': 9, 'x4': 21, 'x5': 25, 'x6': 15}, 
            'r3': {'description': 'organization score', 'upper_bound': 752, 'x0': 24, 'x1': 10, 'x2': 26, 'x3': 15, 'x4': 3, 'x5': 23, 'x6': 2}, 
            'r4': {'description': 'paperwork competence rating', 'upper_bound': 685, 'x0': 8, 'x1': 13, 'x2': 17, 'x3': 18, 'x4': 35, 'x5': 4, 'x6': 24}}
variables = [george_hours, john_hours, laura_hours, bobby_hours, mary_hours, hank_hours, paul_hours]

# Add resource constraints
for r_key, r_data in resources.items():
    for i in range(2, 4):  # Iterate through combinations of 2 and 3 variables
        for j in range(7):
            for k in range(j + 1, 7):
                if i == 3:
                    for l in range(k + 1, 7):
                        model.addConstr(r_data['x' + str(j)] * variables[j] + r_data['x' + str(k)] * variables[k] + r_data['x' + str(l)] * variables[l] >= 61) # Placeholder value, replace with actual lower bound
                        model.addConstr(r_data['x' + str(j)] * variables[j] + r_data['x' + str(k)] * variables[k] + r_data['x' + str(l)] * variables[l] <= r_data['upper_bound'])
                elif i == 2:
                    model.addConstr(r_data['x' + str(j)] * variables[j] + r_data['x' + str(k)] * variables[k] >= 41) # Placeholder value, replace with actual lower bound
                    model.addConstr(r_data['x' + str(j)] * variables[j] + r_data['x' + str(k)] * variables[k] <= r_data['upper_bound'])


# Add specific constraints provided in the prompt related to computer competence, likelihood to quit, etc.  
# ... (Add the constraints here as shown in the example below)

model.addConstr(24 * laura_hours + 34 * bobby_hours >= 95)
model.addConstr(9 * george_hours + 3 * hank_hours >= 41)
# ... (Add the rest of the constraints)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print('Optimization was stopped with status %d' % model.status)
    # Model is infeasible - compute IIS
    model.computeIIS()
    model.write("model.ilp")
    print('\nThe following constraint(s) cannot be satisfied:')
    for c in model.getConstrs():
        if c.IISConstr:
            print('%s' % c.constrName)
