
from gurobipy import *

# Create a Gurobi model
model = Model("Work Hours Optimization")

# Define variables
G = model.addVar(lb=0, name="George", vtype=GRB.CONTINUOUS)
J = model.addVar(lb=0, name="John", vtype=GRB.CONTINUOUS)
L = model.addVar(lb=0, name="Laura", vtype=GRB.CONTINUOUS)
B = model.addVar(lb=0, name="Bobby", vtype=GRB.CONTINUOUS)
M = model.addVar(lb=0, name="Mary", vtype=GRB.CONTINUOUS)
H = model.addVar(lb=0, name="Hank", vtype=GRB.CONTINUOUS)
P = model.addVar(lb=0, name="Paul", vtype=GRB.CONTINUOUS)

# Constraint 1: Total hours for John and George
model.addConstr(J + G >= 72, name="Total Hours for J&G")

# Add other constraints based on the problem statement
# For example:
# Organization score constraint for John and Mary
model.addConstr(0.5*J + 0.7*M <= 465, name="OrgScore_JM")
# Paperwork competence rating for George and Paul
model.addConstr(0.2*G + 0.3*P <= 561, name="Paper_G&P")

# Since the objective function is not specified, we'll set a simple one to maximize total hours worked
model.setObjective(G + J + L + B + M + H + P, GRB.MAXIMIZE)

# Optimize model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print("%s = %g" % (v.varName, v.x))
else:
    print("No optimal solution found")
