
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
G = m.addVar(name="G", lb=0)  # Hours worked by George
J = m.addVar(name="J", lb=0)  # Hours worked by John
L = m.addVar(name="L", lb=0)  # Hours worked by Laura
B = m.addVar(name="B", lb=0)  # Hours worked by Bobby
M = m.addVar(name="M", lb=0)  # Hours worked by Mary
H = m.addVar(name="H", lb=0)  # Hours worked by Hank
P = m.addVar(name="P", lb=0)  # Hours worked by Paul

# Objective function: Maximize
m.setObjective(6.15*G + 4.52*J + 6.66*L + 7.61*B + 1.6*M + 4.75*H + 6.55*P, gp.GRB.MAXIMIZE)

# Constraints
# Computer competence rating constraints
m.addConstr(9*G + 8*J + 24*L + 34*B + 34*M + 3*H + 20*P <= 747, "r0")
# Likelihood to quit index constraints
m.addConstr(33*G + 20*J + 4*L + 13*B + 1*M + 11*H + 5*P <= 734, "r1")
# Work quality rating constraints
m.addConstr(14*G + 17*J + 8*L + 9*B + 21*M + 25*H + 15*P <= 804, "r2")
# Organization score constraints
m.addConstr(24*G + 10*J + 26*L + 15*B + 3*M + 23*H + 2*P <= 752, "r3")
# Paperwork competence rating constraints
m.addConstr(8*G + 13*J + 17*L + 18*B + 35*M + 4*H + 24*P <= 685, "r4")

# Additional constraints
m.addConstr(24*L + 34*B >= 95)
m.addConstr(9*G + 8*J + 24*H >= 41)
m.addConstr(8*J + 13*M >= 104)
m.addConstr(24*L + 20*P >= 88)
m.addConstr(8*J + 24*B >= 42)
m.addConstr(9*G + 24*L >= 50)
m.addConstr(9*G + 8*J >= 37)
m.addConstr(24*L + 34*B + 35*M >= 93)
m.addConstr(9*G + 8*J + 24*H >= 55)
m.addConstr(33*M + 11*P >= 56)
m.addConstr(33*G + 11*H >= 74)
m.addConstr(33*G + 20*J >= 70)
m.addConstr(4*L + 5*P >= 68)
m.addConstr(13*B + 5*P >= 94)
m.addConstr(33*G + 5*P >= 41)
m.addConstr(33*M + 11*H >= 74)
m.addConstr(4*L + 13*B >= 86)
m.addConstr(33*G + 11*H + 5*P >= 85)
m.addConstr(33*G + 4*L + 33*M >= 85)
m.addConstr(33*G + 11*H + 5*P >= 102)
m.addConstr(14*B + 21*M >= 88)
m.addConstr(14*G + 25*H >= 99)
m.addConstr(17*J + 15*P >= 110)
m.addConstr(14*G + 17*J >= 61)
m.addConstr(8*L + 21*M >= 45)
m.addConstr(14*G + 8*L >= 60)
m.addConstr(9*B + 25*H >= 76)
m.addConstr(17*J + 21*M >= 110)
m.addConstr(14*G + 21*M >= 105)
m.addConstr(8*L + 15*P >= 64)
m.addConstr(25*H + 15*P >= 46)
m.addConstr(9*B + 25*H + 15*P >= 102)
m.addConstr(8*L + 21*M + 25*H >= 102)
m.addConstr(14*G + 8*L + 25*H >= 102)
m.addConstr(14*G + 17*J + 9*B >= 102)
m.addConstr(14*G + 17*J + 21*M >= 102)
m.addConstr(17*J + 25*H + 15*P >= 102)
m.addConstr(17*J + 8*L + 9*B >= 102)
m.addConstr(14*G + 8*L + 21*M >= 102)
m.addConstr(14*G + 17*J + 15*P >= 102)
m.addConstr(14*G + 8*L + 9*B >= 102)
m.addConstr(9*B + 21*M + 25*H >= 102)
m.addConstr(14*G + 25*H + 15*P >= 102)
m.addConstr(14*G + 21*M + 25*H >= 102)
m.addConstr(8*L + 9*B + 25*H >= 102)
m.addConstr(8*L + 21*M + 25*H >= 102)
m.addConstr(9*B + 25*H + 15*P >= 113)
m.addConstr(8*L + 21*M + 25*H >= 113)
m.addConstr(14*G + 8*L + 25*H >= 113)
m.addConstr(14*G + 8*L + 15*P >= 113)
m.addConstr(14*G + 17*J + 25*H >= 113)
m.addConstr(17*J + 8*L + 15*P >= 113)
m.addConstr(14*G + 17*J + 9*B >= 113)
m.addConstr(14*G + 17*J + 21*M >= 113)
m.addConstr(17*J + 25*H + 15*P >= 113)
m.addConstr(17*J + 8*L + 9*B >= 113)
m.addConstr(14*G + 8*L + 21*M >= 113)
m.addConstr(14*G + 17*J + 15*P >= 113)
m.addConstr(14*G + 8*L + 9*B >= 113)
m.addConstr(9*B + 21*M + 25*H >= 113)
m.addConstr(14*G + 25*H + 15*P >= 113)
m.addConstr(14*G + 21*M + 25*H >= 113)
m.addConstr(8*L + 9*B + 25*H >= 113)
m.addConstr(8*L + 21*M + 25*H >= 113)

# Solve the problem
m.optimize()

# Output the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by George: ", G.varValue)
    print("Hours worked by John: ", J.varValue)
    print("Hours worked by Laura: ", L.varValue)
    print("Hours worked by Bobby: ", B.varValue)
    print("Hours worked by Mary: ", M.varValue)
    print("Hours worked by Hank: ", H.varValue)
    print("Hours worked by Paul: ", P.varValue)
else:
    print("The problem is infeasible.")
