
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
magnesium = m.addVar(lb=0, name="magnesium")
vitamin_b7 = m.addVar(lb=0, name="vitamin_b7")
vitamin_b4 = m.addVar(lb=0, name="vitamin_b4")
vitamin_b3 = m.addVar(lb=0, name="vitamin_b3")

# Set objective function
m.setObjective(2.99 * magnesium + 9.81 * vitamin_b7 + 2.56 * vitamin_b4 + 7.53 * vitamin_b3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * magnesium + 5 * vitamin_b7 + 25 * vitamin_b4 + 6 * vitamin_b3 <= 139, "digestive_support_index")
m.addConstr(14 * magnesium + 23 * vitamin_b7 + 25 * vitamin_b4 + 18 * vitamin_b3 <= 263, "immune_support_index")
m.addConstr(22 * magnesium + 10 * vitamin_b7 + 2 * vitamin_b4 + 3 * vitamin_b3 <= 121, "kidney_support_index")

m.addConstr(7 * magnesium + 25 * vitamin_b4 >= 11, "digestive_support_combined1")
m.addConstr(25 * vitamin_b4 + 18 * vitamin_b3 >= 22, "immune_support_combined1")
m.addConstr(23 * vitamin_b7 + 18 * vitamin_b3 >= 36, "immune_support_combined2")
m.addConstr(14 * magnesium + 25 * vitamin_b4 >= 50, "immune_support_combined3")
m.addConstr(14 * magnesium + 23 * vitamin_b7 + 25 * vitamin_b4 >= 61, "immune_support_combined4")
m.addConstr(14 * magnesium + 25 * vitamin_b4 + 18 * vitamin_b3 >= 61, "immune_support_combined5")
m.addConstr(14 * magnesium + 23 * vitamin_b7 + 25 * vitamin_b4 >= 45, "immune_support_combined6")
m.addConstr(14 * magnesium + 25 * vitamin_b4 + 18 * vitamin_b3 >= 45, "immune_support_combined7")

m.addConstr(10 * vitamin_b7 + 2 * vitamin_b4 <= 119, "kidney_support_combined1")
m.addConstr(22 * magnesium + 2 * vitamin_b4 <= 101, "kidney_support_combined2")
m.addConstr(22 * magnesium + 3 * vitamin_b3 <= 120, "kidney_support_combined3")
m.addConstr(22 * magnesium + 10 * vitamin_b7 + 2 * vitamin_b4 + 3 * vitamin_b3 <= 120, "kidney_support_combined4")

m.addConstr(7 * magnesium + 5 * vitamin_b7 <= 94, "digestive_support_combined2")
m.addConstr(5 * vitamin_b7 + 25 * vitamin_b4 <= 108, "digestive_support_combined3")
m.addConstr(7 * magnesium + 6 * vitamin_b3 <= 106, "digestive_support_combined4")
m.addConstr(5 * vitamin_b7 + 6 * vitamin_b3 <= 74, "digestive_support_combined5")
m.addConstr(7 * magnesium + 25 * vitamin_b4 <= 136, "digestive_support_combined6")
m.addConstr(25 * vitamin_b4 + 6 * vitamin_b3 <= 40, "digestive_support_combined7")
m.addConstr(7 * magnesium + 5 * vitamin_b7 + 25 * vitamin_b4 + 6 * vitamin_b3 <= 40, "digestive_support_combined8")

m.addConstr(23 * vitamin_b7 + 18 * vitamin_b3 <= 83, "immune_support_combined8")
m.addConstr(14 * magnesium + 25 * vitamin_b4 <= 172, "immune_support_combined9")
m.addConstr(14 * magnesium + 23 * vitamin_b7 <= 182, "immune_support_combined10")
m.addConstr(14 * magnesium + 18 * vitamin_b3 <= 73, "immune_support_combined11")
m.addConstr(14 * magnesium + 23 * vitamin_b7 + 25 * vitamin_b4 + 18 * vitamin_b3 <= 73, "immune_support_combined12")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

