
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
magnesium = m.addVar(name="magnesium", lb=0)  # Non-negative
vitamin_B7 = m.addVar(name="vitamin_B7", lb=0)  # Non-negative
vitamin_B4 = m.addVar(name="vitamin_B4", lb=0)  # Non-negative
vitamin_B3 = m.addVar(name="vitamin_B3", lb=0)  # Non-negative

# Objective function
m.setObjective(2.99 * magnesium + 9.81 * vitamin_B7 + 2.56 * vitamin_B4 + 7.53 * vitamin_B3, gp.GRB.MAXIMIZE)

# Constraints
# Individual support indices
m.addConstr(magnesium * 22 + vitamin_B7 * 10 + vitamin_B4 * 2 + vitamin_B3 * 3 <= 121, "kidney_support")
m.addConstr(magnesium * 7 + vitamin_B7 * 5 + vitamin_B4 * 25 + vitamin_B3 * 6 <= 139, "digestive_support")
m.addConstr(magnesium * 14 + vitamin_B7 * 23 + vitamin_B4 * 25 + vitamin_B3 * 18 <= 263, "immune_support")

# Combined support indices
m.addConstr(magnesium * 7 + vitamin_B4 * 25 >= 11, "min_digestive_magnesium_B4")
m.addConstr(vitamin_B4 * 25 + vitamin_B3 * 18 >= 22, "min_immune_B4_B3")
m.addConstr(vitamin_B7 * 23 + vitamin_B3 * 18 >= 36, "min_immune_B7_B3")
m.addConstr(magnesium * 14 + vitamin_B4 * 25 >= 50, "min_immune_magnesium_B4")
m.addConstr(magnesium * 14 + vitamin_B7 * 23 + vitamin_B4 * 25 >= 61, "min_immune_magnesium_B7_B4")
m.addConstr(magnesium * 14 + vitamin_B4 * 25 + vitamin_B3 * 18 >= 61, "min_immune_magnesium_B4_B3")
m.addConstr(magnesium * 14 + vitamin_B4 * 25 + vitamin_B3 * 18 >= 45, "min_immune_magnesium_B4_B3_2")
m.addConstr(magnesium * 14 + vitamin_B7 * 23 + vitamin_B4 * 25 >= 45, "min_immune_magnesium_B7_B4_2")

# Kidney support indices
m.addConstr(vitamin_B7 * 10 + vitamin_B4 * 2 <= 119, "max_kidney_B7_B4")
m.addConstr(magnesium * 22 + vitamin_B4 * 2 <= 101, "max_kidney_magnesium_B4")
m.addConstr(magnesium * 22 + vitamin_B3 * 3 <= 120, "max_kidney_magnesium_B3")
m.addConstr(magnesium * 22 + vitamin_B7 * 10 + vitamin_B4 * 2 + vitamin_B3 * 3 <= 120, "max_kidney_all")

# Digestive support indices
m.addConstr(magnesium * 7 + vitamin_B7 * 5 <= 94, "max_digestive_magnesium_B7")
m.addConstr(vitamin_B7 * 5 + vitamin_B4 * 25 <= 108, "max_digestive_B7_B4")
m.addConstr(magnesium * 7 + vitamin_B3 * 6 <= 106, "max_digestive_magnesium_B3")
m.addConstr(vitamin_B7 * 5 + vitamin_B3 * 6 <= 74, "max_digestive_B7_B3")
m.addConstr(magnesium * 7 + vitamin_B4 * 25 <= 136, "max_digestive_magnesium_B4")
m.addConstr(vitamin_B4 * 25 + vitamin_B3 * 6 <= 40, "max_digestive_B4_B3")
m.addConstr(magnesium * 7 + vitamin_B7 * 5 + vitamin_B4 * 25 + vitamin_B3 * 6 <= 40, "max_digestive_all")

# Immune support indices
m.addConstr(vitamin_B7 * 23 + vitamin_B3 * 18 <= 83, "max_immune_B7_B3")
m.addConstr(magnesium * 14 + vitamin_B4 * 25 <= 172, "max_immune_magnesium_B4")
m.addConstr(magnesium * 14 + vitamin_B7 * 23 <= 182, "max_immune_magnesium_B7")
m.addConstr(magnesium * 14 + vitamin_B3 * 18 <= 73, "max_immune_magnesium_B3")
m.addConstr(magnesium * 14 + vitamin_B7 * 23 + vitamin_B4 * 25 + vitamin_B3 * 18 <= 73, "max_immune_all")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Magnesium: {magnesium.varValue}")
    print(f"Vitamin B7: {vitamin_B7.varValue}")
    print(f"Vitamin B4: {vitamin_B4.varValue}")
    print(f"Vitamin B3: {vitamin_B3.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
