
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
potassium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potassium")
vitamin_b2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b2")

# Set objective function
m.setObjective(6 * potassium + 2 * vitamin_b2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(26 * potassium + 7 * vitamin_b2 >= 19, "immune_support_min")
m.addConstr(25 * potassium + 21 * vitamin_b2 >= 22, "kidney_support_min")
m.addConstr(-6 * potassium + 6 * vitamin_b2 >= 0, "potassium_vitamin_b2_ratio")
m.addConstr(26 * potassium + 7 * vitamin_b2 <= 48, "immune_support_max") # Corrected upper bound constraint
m.addConstr(25 * potassium + 21 * vitamin_b2 <= 45, "kidney_support_max") # Corrected upper bound constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Milligrams of Potassium: {potassium.x}")
    print(f"  Milligrams of Vitamin B2: {vitamin_b2.x}")
    print(f"  Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

