
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(name='milligrams_of_potassium', lb=0, ub=GRB.INFINITY)
x1 = m.addVar(name='milligrams_of_vitamin_B2', lb=0, ub=GRB.INFINITY)

# Objective function: Minimize 6*x0 + 2*x1
m.setObjective(6*x0 + 2*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(26*x0 + 7*x1 >= 19, name='immune_support_index_min')
m.addConstr(25*x0 + 21*x1 >= 22, name='kidney_support_index_min')
m.addConstr(x1 >= x0, name='vitamin_b2_vs_potassium')
m.addConstr(26*x0 + 7*x1 <= 48, name='immune_support_index_max')
m.addConstr(25*x0 + 21*x1 <= 45, name='kidney_support_index_max')

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Potassium: {x0.x}")
    print(f"Milligrams of Vitamin B2: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
