
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    potassium = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="potassium")
    vitamin_B2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="vitamin_B2")

    # Define the objective function
    model.setObjective(6 * potassium + 2 * vitamin_B2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(26 * potassium + 7 * vitamin_B2 >= 19, name="immune_support_min")
    model.addConstr(26 * potassium + 7 * vitamin_B2 <= 48, name="immune_support_max")
    model.addConstr(25 * potassium + 21 * vitamin_B2 >= 22, name="kidney_support_min")
    model.addConstr(25 * potassium + 21 * vitamin_B2 <= 45, name="kidney_support_max")
    model.addConstr(-6 * potassium + 6 * vitamin_B2 >= 0, name="balance_constraint")

    # Solve the problem
    model.optimize()

    # Check if the problem is infeasible
    if model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The problem is infeasible.")
        return

    # Print the solution
    print("Optimal milligrams of potassium:", potassium.varValue)
    print("Optimal milligrams of vitamin B2:", vitamin_B2.varValue)
    print("Optimal objective value:", model.objVal)

# Run the optimization problem
optimize_problem()
