
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
mary_hours = model.addVar(vtype=gp.GRB.INTEGER, name="mary_hours")
dale_hours = model.addVar(vtype=gp.GRB.CONTINUOUS, name="dale_hours")
peggy_hours = model.addVar(vtype=gp.GRB.INTEGER, name="peggy_hours")
paul_hours = model.addVar(vtype=gp.GRB.INTEGER, name="paul_hours")

# Set objective function
model.setObjective(3 * mary_hours + 4 * dale_hours + 3 * peggy_hours + 8 * paul_hours, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * mary_hours + 4 * peggy_hours + 17 * paul_hours >= 59, "c1")
model.addConstr(2 * mary_hours + 6 * dale_hours + 4 * peggy_hours >= 59, "c2")
model.addConstr(2 * mary_hours + 6 * dale_hours + 17 * paul_hours >= 59, "c3")
model.addConstr(2 * mary_hours + 4 * peggy_hours + 17 * paul_hours >= 34, "c4")
model.addConstr(2 * mary_hours + 6 * dale_hours + 4 * peggy_hours >= 34, "c5")
model.addConstr(2 * mary_hours + 6 * dale_hours + 17 * paul_hours >= 34, "c6")
model.addConstr(2 * mary_hours + 4 * peggy_hours + 17 * paul_hours >= 29, "c7")
model.addConstr(2 * mary_hours + 6 * dale_hours + 4 * peggy_hours >= 29, "c8")
model.addConstr(2 * mary_hours + 6 * dale_hours + 17 * paul_hours >= 29, "c9")
model.addConstr(6 * dale_hours + 4 * peggy_hours <= 73, "c10")
model.addConstr(2 * mary_hours + 4 * peggy_hours + 17 * paul_hours <= 124, "c11")
model.addConstr(6 * dale_hours + 4 * peggy_hours + 17 * paul_hours <= 118, "c12")
model.addConstr(2 * mary_hours + 6 * dale_hours + 4 * peggy_hours <= 69, "c13")
model.addConstr(2 * mary_hours + 6 * dale_hours + 4 * peggy_hours + 17 * paul_hours <= 69, "c14")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Mary Hours: %g' % mary_hours.x)
    print('Dale Hours: %g' % dale_hours.x)
    print('Peggy Hours: %g' % peggy_hours.x)
    print('Paul Hours: %g' % paul_hours.x)
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")
