
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    M = model.addVar(name="Mary", vtype=gurobi.GRB.INTEGER)  # Hours worked by Mary
    D = model.addVar(name="Dale")  # Hours worked by Dale
    P = model.addVar(name="Peggy", vtype=gurobi.GRB.INTEGER)  # Hours worked by Peggy
    Pa = model.addVar(name="Paul", vtype=gurobi.GRB.INTEGER)  # Hours worked by Paul

    # Objective function
    model.setObjective(3 * M + 4 * D + 3 * P + 8 * Pa, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Individual computer competence ratings
    model.addConstr(2 * M + 6 * D + 4 * P + 17 * Pa >= 59)  
    model.addConstr(2 * M + 6 * D + 4 * P >= 59)  
    model.addConstr(2 * M + 6 * D + 17 * Pa >= 59)  
    model.addConstr(2 * M + 4 * P + 17 * Pa >= 34)  
    model.addConstr(2 * M + 6 * D + 4 * P >= 34)  
    model.addConstr(2 * M + 6 * D + 17 * Pa >= 34)  
    model.addConstr(2 * M + 4 * P + 17 * Pa >= 29)  
    model.addConstr(2 * M + 6 * D + 4 * P >= 29)  
    model.addConstr(2 * M + 6 * D + 17 * Pa >= 29)

    # Upper bound constraints
    model.addConstr(6 * D + 4 * P <= 73)
    model.addConstr(2 * M + 4 * P + 17 * Pa <= 124)
    model.addConstr(6 * D + 4 * P + 17 * Pa <= 118)
    model.addConstr(2 * M + 6 * D + 4 * P <= 69)
    model.addConstr(2 * M + 6 * D + 4 * P + 17 * Pa <= 69)

    # Bounds for variables (non-negativity assumed for hours worked)
    M.lb = 0
    D.lb = 0
    P.lb = 0
    Pa.lb = 0

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Mary: ", M.x)
        print("Hours worked by Dale: ", D.x)
        print("Hours worked by Peggy: ", P.x)
        print("Hours worked by Paul: ", Pa.x)
    else:
        print("The model is infeasible")

solve_optimization_problem()
