
import gurobipy as gp

# Create a new model
m = gp.Model("PlantOptimization")

# Create variables
chili_plants = m.addVar(vtype=gp.GRB.INTEGER, name="chili_plants")
lilies = m.addVar(vtype=gp.GRB.INTEGER, name="lilies")
decorative_cabbages = m.addVar(vtype=gp.GRB.INTEGER, name="decorative_cabbages")
ferns = m.addVar(vtype=gp.GRB.INTEGER, name="ferns")

# Set objective function
m.setObjective(9.63 * chili_plants + 1.35 * lilies + 9.63 * decorative_cabbages + 7.06 * ferns, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(18 * chili_plants + 26 * lilies + 12 * decorative_cabbages + 18 * ferns <= 385, "Total Beauty Rating") # Resource constraint r0
m.addConstr(20 * chili_plants + 23 * lilies + 8 * decorative_cabbages + 23 * ferns <= 389, "Total Water Need") # Resource constraint r1

m.addConstr(26 * lilies + 12 * decorative_cabbages >= 94, "Beauty lilies + cabbages")
m.addConstr(18 * chili_plants + 12 * decorative_cabbages >= 48, "Beauty chili_plants + cabbages")
m.addConstr(12 * decorative_cabbages + 18 * ferns >= 74, "Beauty cabbages + ferns")
m.addConstr(26 * lilies + 18 * ferns >= 71, "Beauty lilies + ferns")
m.addConstr(18 * chili_plants + 26 * lilies >= 51, "Beauty chili_plants + lilies")
m.addConstr(18 * chili_plants + 12 * decorative_cabbages + 18 * ferns >= 74, "Beauty chili_plants + cabbages + ferns")

m.addConstr(20 * chili_plants + 23 * ferns >= 65, "Water chili_plants + ferns")
m.addConstr(20 * chili_plants + 8 * decorative_cabbages >= 43, "Water chili_plants + cabbages")
m.addConstr(8 * decorative_cabbages + 23 * ferns >= 58, "Water cabbages + ferns")
m.addConstr(23 * lilies + 8 * decorative_cabbages >= 87, "Water lilies + cabbages")
m.addConstr(20 * chili_plants + 23 * lilies >= 77, "Water chili_plants + lilies")


m.addConstr(26 * lilies + 12 * decorative_cabbages <= 317, "Beauty lilies + cabbages max")
m.addConstr(18 * chili_plants + 18 * ferns <= 380, "Beauty chili_plants + ferns max")
m.addConstr(18 * chili_plants + 12 * decorative_cabbages <= 243, "Beauty chili_plants + cabbages max")
m.addConstr(18 * chili_plants + 26 * lilies + 12 * decorative_cabbages + 18 * ferns <= 243, "Total Beauty max")

m.addConstr(23 * lilies + 8 * decorative_cabbages <= 227, "Water lilies + cabbages max")
m.addConstr(23 * lilies + 23 * ferns <= 107, "Water lilies + ferns max")
m.addConstr(20 * chili_plants + 8 * decorative_cabbages + 23 * ferns <= 304, "Water chili_plants + cabbages + ferns max")
m.addConstr(20 * chili_plants + 23 * lilies + 8 * decorative_cabbages + 23 * ferns <= 304, "Total Water max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

