
import gurobi as gp

# Create a new model
m = gp.Model("plant_optimization")

# Define the variables
x0 = m.addVar(name="chili_plants", vtype=gp.GRB.INTEGER)  # chili plants
x1 = m.addVar(name="lilies", vtype=gp.GRB.INTEGER)    # lilies
x2 = m.addVar(name="decorative_cabbages", vtype=gp.GRB.INTEGER)  # decorative cabbages
x3 = m.addVar(name="ferns", vtype=gp.GRB.INTEGER)      # ferns

# Define the objective function
m.setObjective(9.63*x0 + 1.35*x1 + 9.63*x2 + 7.06*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(18*x0 + 26*x1 + 12*x2 + 18*x3 <= 385, "total_beauty")
m.addConstr(20*x0 + 23*x1 + 8*x2 + 23*x3 <= 389, "total_water")

m.addConstr(26*x1 + 12*x2 >= 94, "lilies_cabbages_beauty")
m.addConstr(18*x0 + 12*x2 >= 48, "chili_cabbages_beauty")
m.addConstr(12*x2 + 18*x3 >= 74, "cabbages_ferns_beauty")
m.addConstr(26*x1 + 18*x3 >= 71, "lilies_ferns_beauty")
m.addConstr(18*x0 + 26*x1 >= 51, "chili_lilies_beauty")
m.addConstr(18*x0 + 12*x2 + 18*x3 >= 74, "chili_cabbages_ferns_beauty")

m.addConstr(20*x0 + 23*x3 >= 65, "chili_ferns_water")
m.addConstr(20*x0 + 8*x2 >= 43, "chili_cabbages_water")
m.addConstr(8*x2 + 23*x3 >= 58, "cabbages_ferns_water")
m.addConstr(23*x1 + 8*x2 >= 87, "lilies_cabbages_water")
m.addConstr(20*x0 + 23*x1 >= 77, "chili_lilies_water")

m.addConstr(26*x1 + 12*x2 <= 317, "lilies_cabbages_beauty_upper")
m.addConstr(18*x0 + 18*x3 <= 380, "chili_ferns_beauty_upper")
m.addConstr(18*x0 + 12*x2 <= 243, "chili_cabbages_beauty_upper")
m.addConstr(18*x0 + 26*x1 + 12*x2 + 18*x3 <= 385, "total_beauty_upper")

m.addConstr(23*x1 + 8*x2 <= 227, "lilies_cabbages_water_upper")
m.addConstr(23*x1 + 23*x3 <= 107, "lilies_ferns_water_upper")
m.addConstr(20*x0 + 8*x2 + 23*x3 <= 304, "chili_cabbages_ferns_water_upper")
m.addConstr(20*x0 + 23*x1 + 8*x2 + 23*x3 <= 304, "total_water_upper")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Chili plants: ", x0.varValue)
    print("Lilies: ", x1.varValue)
    print("Decorative cabbages: ", x2.varValue)
    print("Ferns: ", x3.varValue)
else:
    print("The model is infeasible")
