
from gurobipy import Model, GRB

# Create a new model
model = Model("calcium_optimization")

# Create variables
bananas = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bananas")
eggs = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="eggs")
chickens = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="rotisserie_chickens")

# Set objective function
model.setObjective(7 * bananas + 4 * eggs + 9 * chickens, GRB.MINIMIZE)

# Add constraints
model.addConstr(18 * bananas + 6 * chickens >= 18, "calcium_constraint1")
model.addConstr(3 * eggs + 6 * chickens >= 18, "calcium_constraint2")
model.addConstr(18 * bananas + 3 * eggs + 6 * chickens >= 18, "calcium_constraint3")
model.addConstr(4 * bananas - 6 * chickens >= 0, "constraint4")
model.addConstr(8 * eggs - 9 * chickens >= 0, "constraint5")
model.addConstr(18*bananas + 3*eggs + 6*chickens <= 164, "calcium_upper_bound")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print('Optimal objective:', model.objVal)
    print('Bananas:', bananas.x)
    print('Eggs:', eggs.x)
    print('Rotisserie Chickens:', chickens.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f"Optimization ended with status {model.status}")

