
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
bananas = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bananas")
eggs = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="eggs")
rotisserie_chickens = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="rotisserie_chickens")

# Define the objective function
m.setObjective(7 * bananas + 4 * eggs + 9 * rotisserie_chickens, GRB.MINIMIZE)

# Add constraints
m.addConstr(18 * bananas + 6 * rotisserie_chickens >= 18, name="calcium_bananas_rotisserie")
m.addConstr(3 * eggs + 6 * rotisserie_chickens >= 18, name="calcium_eggs_rotisserie")
m.addConstr(18 * bananas + 3 * eggs + 6 * rotisserie_chickens >= 18, name="calcium_all_sources")
m.addConstr(4 * bananas - 6 * rotisserie_chickens >= 0, name="bananas_rotisserie_constraint")
m.addConstr(8 * eggs - 9 * rotisserie_chickens >= 0, name="eggs_rotisserie_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Bananas:", bananas.x)
    print("Eggs:", eggs.x)
    print("Rotisserie Chickens:", rotisserie_chickens.x)
else:
    print("No optimal solution found. Status:", m.status)
