
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    bananas = model.addVar(lb=0, name="bananas", vtype=gurobi.GRB.CONTINUOUS)
    eggs = model.addVar(lb=0, name="eggs", vtype=gurobi.GRB.CONTINUOUS)
    rotisserie_chickens = model.addVar(lb=0, name="rotisserie_chickens", vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(7 * bananas + 4 * eggs + 9 * rotisserie_chickens, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(18 * bananas + 3 * eggs + 6 * rotisserie_chickens <= 164, name="calcium_constraint")
    model.addConstr(18 * bananas + 6 * rotisserie_chickens >= 18, name="calcium_from_bananas_and_chickens")
    model.addConstr(3 * eggs + 6 * rotisserie_chickens >= 18, name="calcium_from_eggs_and_chickens")
    model.addConstr(18 * bananas + 3 * eggs + 6 * rotisserie_chickens >= 18, name="total_calcium_constraint")
    model.addConstr(4 * bananas - 6 * rotisserie_chickens >= 0, name="bananas_and_chickens_constraint")
    model.addConstr(8 * eggs - 9 * rotisserie_chickens >= 0, name="eggs_and_chickens_constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Bananas: {bananas.varValue}")
        print(f"Eggs: {eggs.varValue}")
        print(f"Rotisserie Chickens: {rotisserie_chickens.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("No feasible solution found.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
