
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
milk = m.addVar(vtype=GRB.INTEGER, name="milk")
napkins = m.addVar(vtype=GRB.INTEGER, name="napkins")
plates = m.addVar(vtype=GRB.INTEGER, name="plates")

# Set objective function
m.setObjective(3 * milk + 3 * napkins + 5 * plates, GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * napkins + 23 * plates >= 35, "c1")
m.addConstr(15 * milk + 8 * napkins >= 96, "c2")
m.addConstr(15 * milk + 8 * napkins + 23 * plates >= 96, "c3")
m.addConstr(4 * milk + 17 * plates >= 84, "c4")
m.addConstr(4 * milk + 1 * napkins >= 58, "c5")
m.addConstr(4 * milk + 1 * napkins + 17 * plates >= 89, "c6")
m.addConstr(-4 * milk + 7 * plates >= 0, "c7")
m.addConstr(15 * milk + 8 * napkins + 23 * plates <= 221, "c8")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal Solution:")
    print(f"Milk: {milk.x}")
    print(f"Napkins: {napkins.x}")
    print(f"Plates: {plates.x}")
    print(f"Objective Value: {m.objVal}")

