
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="cartons_of_milk")
x1 = m.addVar(vtype=GRB.INTEGER, name="packs_of_napkins")
x2 = m.addVar(vtype=GRB.INTEGER, name="packs_of_paper_plates")

# Objective function: Minimize 3*x0 + 3*x1 + 5*x2
m.setObjective(3*x0 + 3*x1 + 5*x2, GRB.MINIMIZE)

# Constraints
# Minimum spending constraints
m.addConstr(8*x1 + 23*x2 >= 35, name="min_spend_napkins_paperplates")
m.addConstr(15*x0 + 8*x1 >= 96, name="min_spend_milk_napkins")
m.addConstr(15*x0 + 8*x1 + 23*x2 >= 96, name="total_min_spend")

# Usefulness rating constraints
m.addConstr(4*x0 + 17*x2 >= 84, name="usefulness_milk_paperplates")
m.addConstr(4*x0 + x1 >= 58, name="usefulness_milk_napkins")
m.addConstr(4*x0 + x1 + 17*x2 >= 89, name="total_usefulness")

# Additional linear constraint
m.addConstr(-4*x0 + 7*x2 >= 0, name="additional_linear_constraint")

# Maximum total spending constraint
m.addConstr(15*x0 + 8*x1 + 23*x2 <= 221, name="max_total_spend")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cartons of milk: {x0.x}")
    print(f"Packs of napkins: {x1.x}")
    print(f"Packs of paper plates: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
