
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="cartons_of_milk", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="packs_of_napkins", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="packs_of_paper_plates", vtype=gurobi.GRB.INTEGER)

    # Objective function: Minimize 3*x0 + 3*x1 + 5*x2
    model.setObjective(3*x0 + 3*x1 + 5*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(15*x0 + 8*x1 + 23*x2 <= 304, name="total_cost")
    model.addConstr(8*x1 + 23*x2 >= 35, name="min_spend_napkins_paper_plates")
    model.addConstr(15*x0 + 8*x1 >= 96, name="min_spend_milk_napkins")
    model.addConstr(4*x0 + 17*x2 >= 84, name="usefulness_milk_paper_plates")
    model.addConstr(4*x0 + x1 >= 58, name="min_usefulness_milk_napkins")
    model.addConstr(4*x0 + x1 + 17*x2 >= 89, name="total_usefulness")
    model.addConstr(-4*x0 + 7*x2 >= 0, name="relationship_milk_paper_plates")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Cartons of milk: {x0.varValue}")
        print(f"Packs of napkins: {x1.varValue}")
        print(f"Packs of paper plates: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible")

optimize_problem()
