
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
peggy = m.addVar(vtype=gp.GRB.INTEGER, name="peggy")
john = m.addVar(vtype=gp.GRB.CONTINUOUS, name="john")
paul = m.addVar(vtype=gp.GRB.CONTINUOUS, name="paul")
hank = m.addVar(vtype=gp.GRB.CONTINUOUS, name="hank")
dale = m.addVar(vtype=gp.GRB.CONTINUOUS, name="dale")
bobby = m.addVar(vtype=gp.GRB.INTEGER, name="bobby")

# Set objective function
m.setObjective(5*peggy + 6*john + 7*paul + 8*hank + 8*dale + 3*bobby, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(18.4*john + 8.96*paul + 15.24*dale >= 43)
m.addConstr(18.4*john + 8.96*paul + 7.28*hank >= 43)
m.addConstr(1.32*peggy + 18.4*john + 8.96*paul >= 43)
m.addConstr(18.4*john + 8.96*paul + 15.24*dale >= 35)
m.addConstr(18.4*john + 8.96*paul + 7.28*hank >= 35)
m.addConstr(1.32*peggy + 18.4*john + 8.96*paul >= 35)
m.addConstr(18.4*john + 8.96*paul + 15.24*dale >= 38)
m.addConstr(18.4*john + 8.96*paul + 7.28*hank >= 38)
m.addConstr(1.32*peggy + 18.4*john + 8.96*paul >= 38)

m.addConstr(13.77*peggy + 16.56*paul >= 44)
m.addConstr(3.56*hank + 14.04*dale >= 30)
m.addConstr(16.56*paul + 9.72*bobby >= 47)
m.addConstr(13.77*peggy + 7.27*john >= 57)
m.addConstr(3.56*hank + 9.72*bobby >= 61)
m.addConstr(14.04*dale + 9.72*bobby >= 34)
m.addConstr(13.77*peggy + 3.56*hank >= 49)
m.addConstr(7.27*john + 3.56*hank >= 28)
m.addConstr(7.27*john + 16.56*paul >= 36)
m.addConstr(16.56*paul + 14.04*dale >= 60)
m.addConstr(7.27*john + 9.72*bobby >= 36)

m.addConstr(1.32*peggy + 18.4*john <= 50)
m.addConstr(7.28*hank + 5.93*bobby <= 234)
m.addConstr(15.24*dale + 5.93*bobby <= 148)
m.addConstr(18.4*john + 8.96*paul + 15.24*dale <= 259)
m.addConstr(7.28*hank + 15.24*dale + 5.93*bobby <= 213)
m.addConstr(1.32*peggy + 18.4*john + 8.96*paul + 7.28*hank + 15.24*dale + 5.93*bobby <= 213)

m.addConstr(13.77*peggy + 16.56*paul <= 64)
m.addConstr(13.77*peggy + 9.72*bobby <= 337)
m.addConstr(16.56*paul + 3.56*hank <= 71)
m.addConstr(7.27*john + 9.72*bobby <= 289)
m.addConstr(7.27*john + 14.04*dale <= 221)
m.addConstr(16.56*paul + 9.72*bobby <= 289)
m.addConstr(3.56*hank + 14.04*dale <= 363)
m.addConstr(3.56*hank + 9.72*bobby <= 85)
m.addConstr(13.77*peggy + 7.27*john <= 271)
m.addConstr(13.77*peggy + 3.56*hank <= 98)
m.addConstr(16.56*paul + 14.04*dale <= 115)
m.addConstr(13.77*peggy + 16.56*paul + 9.72*bobby <= 262)
m.addConstr(13.77*peggy + 14.04*dale + 9.72*bobby <= 186)
m.addConstr(13.77*peggy + 16.56*paul + 14.04*dale <= 306)
m.addConstr(16.56*paul + 3.56*hank + 14.04*dale <= 278)
m.addConstr(7.27*john + 16.56*paul + 14.04*dale <= 293)
m.addConstr(3.56*hank + 14.04*dale + 9.72*bobby <= 298)
m.addConstr(13.77*peggy + 7.27*john + 16.56*paul + 3.56*hank + 14.04*dale + 9.72*bobby <= 298)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

