
from gurobipy import Model, GRB

# Create a new model
m = Model("Military Resource Allocation")

# Create variables
pathfinder_teams = m.addVar(vtype=GRB.INTEGER, name="pathfinder_teams")
artillery_batteries = m.addVar(vtype=GRB.INTEGER, name="artillery_batteries")
cbrn_platoons = m.addVar(vtype=GRB.INTEGER, name="cbrn_platoons")
logistics_companies = m.addVar(vtype=GRB.INTEGER, name="logistics_companies")

# Set objective function
m.setObjective(5 * pathfinder_teams + 3 * artillery_batteries + 5 * cbrn_platoons + 8 * logistics_companies, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8 * artillery_batteries + 15 * logistics_companies >= 45, "mobility_constraint1")
m.addConstr(16 * pathfinder_teams + 10 * cbrn_platoons >= 43, "mobility_constraint2")
m.addConstr(8 * artillery_batteries + 10 * cbrn_platoons >= 49, "mobility_constraint3")
m.addConstr(8 * artillery_batteries + 10 * cbrn_platoons + 15 * logistics_companies >= 58, "mobility_constraint4")
m.addConstr(16 * pathfinder_teams + 10 * cbrn_platoons + 15 * logistics_companies >= 58, "mobility_constraint5")
m.addConstr(8 * artillery_batteries + 10 * cbrn_platoons + 15 * logistics_companies >= 41, "mobility_constraint6")
m.addConstr(16 * pathfinder_teams + 10 * cbrn_platoons + 15 * logistics_companies >= 41, "mobility_constraint7")

m.addConstr(9 * artillery_batteries + 6 * cbrn_platoons >= 62, "offensive_constraint1")
m.addConstr(9 * artillery_batteries + 13 * logistics_companies >= 66, "offensive_constraint2")
m.addConstr(1 * pathfinder_teams + 13 * logistics_companies >= 36, "offensive_constraint3")
m.addConstr(6 * cbrn_platoons + 13 * logistics_companies >= 74, "offensive_constraint4")

m.addConstr(16 * pathfinder_teams + 15 * logistics_companies <= 123, "mobility_constraint8")
m.addConstr(8 * artillery_batteries + 15 * logistics_companies <= 161, "mobility_constraint9")
m.addConstr(16 * pathfinder_teams + 8 * artillery_batteries <= 215, "mobility_constraint10")
m.addConstr(16 * pathfinder_teams + 8 * artillery_batteries + 10 * cbrn_platoons + 15 * logistics_companies <= 215, "mobility_constraint11")

m.addConstr(1 * pathfinder_teams + 6 * cbrn_platoons <= 220, "offensive_constraint5")
m.addConstr(1 * pathfinder_teams + 13 * logistics_companies <= 113, "offensive_constraint6")
m.addConstr(9 * artillery_batteries + 13 * logistics_companies <= 141, "offensive_constraint7")
m.addConstr(6 * cbrn_platoons + 13 * logistics_companies <= 329, "offensive_constraint8")
m.addConstr(1 * pathfinder_teams + 9 * artillery_batteries + 6 * cbrn_platoons + 13 * logistics_companies <= 329, "offensive_constraint9")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")

