
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
pathfinder_teams = m.addVar(name="pathfinder_teams", vtype=gurobi.GRB.INTEGER)
artillery_batteries = m.addVar(name="artillery_batteries", vtype=gurobi.GRB.INTEGER)
CBRN_platoons = m.addVar(name="CBRN_platoons", vtype=gurobi.GRB.INTEGER)
logistics_companies = m.addVar(name="logistics_companies", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(5 * pathfinder_teams + 3 * artillery_batteries + 5 * CBRN_platoons + 8 * logistics_companies, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8 * artillery_batteries + 15 * logistics_companies >= 45)
m.addConstr(16 * pathfinder_teams + 10 * CBRN_platoons >= 43)
m.addConstr(8 * artillery_batteries + 10 * CBRN_platoons >= 49)
m.addConstr(8 * artillery_batteries + 10 * CBRN_platoons + 15 * logistics_companies >= 58)
m.addConstr(16 * pathfinder_teams + 10 * CBRN_platoons + 15 * logistics_companies >= 58)
m.addConstr(8 * artillery_batteries + 10 * CBRN_platoons + 15 * logistics_companies >= 41)
m.addConstr(16 * pathfinder_teams + 10 * CBRN_platoons + 15 * logistics_companies >= 41)
m.addConstr(9 * artillery_batteries + 6 * CBRN_platoons >= 62)
m.addConstr(9 * artillery_batteries + 13 * logistics_companies >= 66)
m.addConstr(pathfinder_teams + 13 * logistics_companies >= 36)
m.addConstr(6 * CBRN_platoons + 13 * logistics_companies >= 74)
m.addConstr(16 * pathfinder_teams + 15 * logistics_companies <= 123)
m.addConstr(8 * artillery_batteries + 15 * logistics_companies <= 161)
m.addConstr(16 * pathfinder_teams + 8 * artillery_batteries <= 215)
m.addConstr(16 * pathfinder_teams + 8 * artillery_batteries + 10 * CBRN_platoons + 15 * logistics_companies <= 215)
m.addConstr(pathfinder_teams + 6 * CBRN_platoons <= 220)
m.addConstr(pathfinder_teams + 13 * logistics_companies <= 113)
m.addConstr(9 * artillery_batteries + 13 * logistics_companies <= 141)
m.addConstr(6 * CBRN_platoons + 13 * logistics_companies <= 329)
m.addConstr(pathfinder_teams + 9 * artillery_batteries + 6 * CBRN_platoons + 13 * logistics_companies <= 329)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Pathfinder Teams: ", pathfinder_teams.varValue)
    print("Artillery Batteries: ", artillery_batteries.varValue)
    print("CBRN Platoons: ", CBRN_platoons.varValue)
    print("Logistics Companies: ", logistics_companies.varValue)
else:
    print("The model is infeasible")
