
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
kale_salads = model.addVar(vtype=GRB.INTEGER, name="kale_salads")
tomatoes = model.addVar(vtype=GRB.INTEGER, name="tomatoes")
strips_of_bacon = model.addVar(vtype=GRB.INTEGER, name="strips_of_bacon")

# Set objective function
model.setObjective(9 * kale_salads + 1 * tomatoes + 6 * strips_of_bacon, GRB.MINIMIZE)

# Add constraints
model.addConstr(3 * kale_salads + 14 * tomatoes >= 20, "tastiness_constraint1")
model.addConstr(14 * tomatoes + 2 * strips_of_bacon >= 13, "tastiness_constraint2")
model.addConstr(3 * kale_salads + 14 * tomatoes + 2 * strips_of_bacon >= 21, "tastiness_constraint3")
model.addConstr(8 * kale_salads + 13 * tomatoes >= 51, "calcium_constraint1")
model.addConstr(13 * tomatoes + 8 * strips_of_bacon >= 45, "calcium_constraint2")
model.addConstr(8 * kale_salads + 8 * strips_of_bacon >= 21, "calcium_constraint3")
model.addConstr(8 * kale_salads + 13 * tomatoes + 8 * strips_of_bacon >= 21, "calcium_constraint4")
model.addConstr(7 * kale_salads + 5 * tomatoes >= 57, "protein_constraint1")
model.addConstr(7 * kale_salads + 5 * tomatoes + 3 * strips_of_bacon >= 57, "protein_constraint2")
model.addConstr(-5 * tomatoes + 4 * strips_of_bacon >= 0, "constraint1")
model.addConstr(-6 * kale_salads + 9 * tomatoes >= 0, "constraint2")
model.addConstr(3 * kale_salads + 14 * tomatoes <= 48, "tastiness_constraint4")


# Resource Constraints (given in the prompt)
model.addConstr(3 * kale_salads + 14 * tomatoes + 2 * strips_of_bacon <= 71, "tastiness_resource")
model.addConstr(8 * kale_salads + 13 * tomatoes + 8 * strips_of_bacon <= 153, "calcium_resource")
model.addConstr(7 * kale_salads + 5 * tomatoes + 3 * strips_of_bacon <= 235, "protein_resource")



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('kale_salads:', kale_salads.x)
    print('tomatoes:', tomatoes.x)
    print('strips_of_bacon:', strips_of_bacon.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

