
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
kale_salads = m.addVar(name="kale_salads", vtype=gp.GRB.INTEGER)
tomatoes = m.addVar(name="tomatoes", vtype=gp.GRB.INTEGER)
strips_of_bacon = m.addVar(name="strips_of_bacon", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(9 * kale_salads + tomatoes + 6 * strips_of_bacon, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(3 * kale_salads + 14 * tomatoes >= 20)  # 10
m.addConstr(14 * tomatoes + 2 * strips_of_bacon >= 13)  # 11
m.addConstr(3 * kale_salads + 14 * tomatoes + 2 * strips_of_bacon >= 21)  # 12
m.addConstr(8 * kale_salads + 13 * tomatoes >= 51)  # 13
m.addConstr(13 * tomatoes + 8 * strips_of_bacon >= 45)  # 14
m.addConstr(8 * kale_salads + 8 * strips_of_bacon >= 21)  # 15
m.addConstr(8 * kale_salads + 13 * tomatoes + 8 * strips_of_bacon >= 21)  # 16
m.addConstr(7 * kale_salads + 5 * tomatoes >= 57)  # 17
m.addConstr(7 * kale_salads + 5 * tomatoes + 3 * strips_of_bacon >= 57)  # 18
m.addConstr(-5 * tomatoes + 4 * strips_of_bacon >= 0)  # 19
m.addConstr(-6 * kale_salads + 9 * tomatoes >= 0)  # 20
m.addConstr(3 * kale_salads + 14 * tomatoes <= 48)  # 21

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Kale Salads: ", kale_salads.varValue)
    print("Tomatoes: ", tomatoes.varValue)
    print("Strips of Bacon: ", strips_of_bacon.varValue)
else:
    print("The model is infeasible")
