
from gurobipy import Model, GRB

# Create a new model
model = Model("Employee_Hours")

# Create variables
laura_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="laura_hours")
ringo_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ringo_hours")

# Set objective function
model.setObjective(8.02 * laura_hours + 3.31 * ringo_hours, GRB.MAXIMIZE)

# Add constraints

# Individual attribute constraints (These are redundant given the combined constraints and individual coefficients, but included for completeness)
model.addConstr(12 * laura_hours == 12 * laura_hours, "laura_lqi") # Redundant
model.addConstr(13 * laura_hours == 13 * laura_hours, "laura_pcr") # Redundant
model.addConstr(16 * laura_hours == 16 * laura_hours, "laura_wqr") # Redundant
model.addConstr(1 * ringo_hours == 1 * ringo_hours, "ringo_lqi") # Redundant
model.addConstr(17 * ringo_hours == 17 * ringo_hours, "ringo_pcr") # Redundant
model.addConstr(16 * ringo_hours == 16 * ringo_hours, "ringo_wqr") # Redundant


# Combined attribute constraints
model.addConstr(12 * laura_hours + 1 * ringo_hours >= 68, "combined_lqi_min")
model.addConstr(12 * laura_hours + 1 * ringo_hours <= 151, "combined_lqi_max")
model.addConstr(13 * laura_hours + 17 * ringo_hours >= 44, "combined_pcr_min")
model.addConstr(13 * laura_hours + 17 * ringo_hours <= 102, "combined_pcr_max")
model.addConstr(16 * laura_hours + 16 * ringo_hours >= 38, "combined_wqr_min")
model.addConstr(16 * laura_hours + 16 * ringo_hours <= 187, "combined_wqr_max")


# Additional constraint
model.addConstr(-5 * laura_hours + 2 * ringo_hours >= 0, "additional_constraint")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Laura's hours: {laura_hours.x}")
    print(f"  Ringo's hours: {ringo_hours.x}")
    print(f"  Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

